//|||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||||
//-----------------------------------------------------------------------------
package gdg3dtetris;

/**
 * Titre :        3D Tetris Game
 * Description :  3D version of the famous Tetris game in Java / Swing.
 * Copyright :    Copyright (c) 2003
 * Socit :      Himself
 * @author Georges Dreiding
 * @version 1.0
 */

import java.util.*;
import java.awt.*;
import java.awt.event.*;
import javax.swing.*;
import javax.swing.event.*;
import javax.swing.border.*;
import java.io.*;
import java.lang.reflect.*;


// =============================================================================
// class =======================================================================
// =============================================================================
public class GDG3DTetris extends JFrame implements GDG3DTetrisCstes {

  //-----------------------------------
  private static String opt_k , opt_h , opt_g;

  private static float opt_t;

  private static int look;

  private static GDG3DTetris game;

  static private JFrame choicePan;

  static private String gameTitle = "gdg 3D Tetris - Java 2 / Swing version";

  //-----------------------------------
  public  Graphics g , gPanNextForme , gPanStages , gPanInst1 , gPanInst2 , gPanInst3 , gPanInst4;

  //-----------------------------------
  private Volume scene , sceneTraining , scenePlaying;
  private Volume forme , nextForme , formeBuff , formeTraining , formePlaying;
  private Volume heap , heapTraining , heapPlaying , heapCloned;

  //-----------------------------------
  private Color colorForme = Color.red;
  private Color colorNextForme = Color.red;

  //-----------------------------------
  private boolean menuDevelopped;

  //-----------------------------------
  private double sizeX = 500;
  private double sizeY = 500;

  private double scaleX = 10;
  private double scaleY = 10;
  private double scaleYNextForme;
  private double scaleXTraining;
  private double scaleYTraining;
  private double scaleXPlaying;
  private double scaleYPlaying;

  //-----------------------------------
  private double oneDeg = Math.PI/180;

  private double tetaX;

  private int dist = -1510;

  private int obsX , obsY , obsZ = 700;
  private int obsXPlaying , obsYPlaying , obsZPlaying = 700;
  private int obsXTraining , obsYTraining , obsZTraining = 700;

  private int offsetX = 500, offsetY = 500;
  private int offsetXPlaying = 500, offsetYPlaying = 500;
  private int offsetXTraining = 500, offsetYTraining = 500;
  private int offsetPan = 20;

  //-----------------------------------
  private boolean trainingMode = false;
  private boolean changingKeysMode = false;
  private boolean changingGameMode = false;
  private boolean pauseMode = false;
  private boolean newGameMode = true;
  private boolean endedGameMode = false;
  private boolean helpMode = false;
  private boolean observeHeapMode = false;
  private boolean formeOnMove = false;

  //-----------------------------------
  private JPanel pan , panButtons , panButtons2 , panNextForme , panStages , panInst1 , panInst2 , panInst3 , panInst4 , cp;

  private int heightPanStages = (int)sizeY , widthPanStages = 100 , XPanStages = offsetPan , YPanStages = offsetPan;

  private int heightPan = (int)sizeY , widthPan = (int)sizeX , XPan = widthPanStages + XPanStages + offsetPan , YPan = YPanStages;

  private int heightPanButtons = heightPan / 2 , widthPanButtons = widthPanStages , XPanButtons = XPanStages , YPanButtons = YPanStages + heightPanStages + offsetPan;

  private int heightPanButtons2 = heightPan / 2 , widthPanButtons2 = widthPanStages , XPanButtons2 = XPanStages , YPanButtons2 = YPanStages + heightPanStages + offsetPan;

  private int heightPanNextForme = heightPan / 2 , widthPanNextForme = widthPan , XPanNextForme = XPan, YPanNextForme = YPanButtons;

  private int widthPanInst = ( widthPan + widthPanButtons + offsetPan ) / 4;

  private int XPanInst = ( widthPan + widthPanButtons + offsetPan ) / 4;

  private int heightPanInst1 = heightPan / 3 , widthPanInst1 = widthPanInst , XPanInst1 = XPanButtons , YPanInst1 = YPanButtons + heightPanButtons + offsetPan;

  private int heightPanInst2 = heightPan / 3 , widthPanInst2 = widthPanInst , XPanInst2 = XPanButtons + XPanInst , YPanInst2 = YPanButtons + heightPanButtons + offsetPan;

  private int heightPanInst3 = heightPan / 3 , widthPanInst3 = widthPanInst , XPanInst3 = XPanButtons + XPanInst * 2 , YPanInst3 = YPanButtons + heightPanButtons + offsetPan;

  private int heightPanInst4 = heightPan / 3 , widthPanInst4 = widthPanInst , XPanInst4 = XPanButtons + XPanInst * 3 , YPanInst4 = YPanButtons + heightPanButtons + offsetPan;

  //-----------------------------------
  private Random rand = new Random();

  //-----------------------------------
  private java.util.Timer timerTop;

  private java.util.Timer timerBigTop;

  private TimerTask flotTop = new TimerTask() {
    public void run()
    {
      pulse();
    }
  };

  private TimerTask flotBigTop = new TimerTask() {
    public void run()
    {
      bigTopPulse();
    }
  };

  //-----------------------------------
  private int XOrgRep = widthPanInst / 2 , YOrgRep = heightPan / 5;
  private int longAxes = 50;

  //-----------------------------------
  private final String[] tabKeys =
  { "0" , "1" , "2" , "3" , "4" , "5" , "6" , "7" , "8" , "9" ,
    "A" , "B" , "C" , "D" , "E" , "F" , "G" , "H" , "I" , "J" , "K" , "L" , "M" , "N" , "O" ,
    "P" , "Q" , "R" , "S" , "T" , "U" , "V" , "W" , "X" , "Y" , "Z" , "Left" , "Right" , "Up" , "Down" };

  private final int[] tabVKeys =
  { KeyEvent.VK_0 , KeyEvent.VK_1 , KeyEvent.VK_2 , KeyEvent.VK_3 , KeyEvent.VK_4 , KeyEvent.VK_5 , KeyEvent.VK_6 , KeyEvent.VK_7 , KeyEvent.VK_8 , KeyEvent.VK_9 ,
    KeyEvent.VK_A , KeyEvent.VK_B , KeyEvent.VK_C , KeyEvent.VK_D , KeyEvent.VK_E , KeyEvent.VK_F , KeyEvent.VK_G , KeyEvent.VK_H , KeyEvent.VK_I , KeyEvent.VK_J , KeyEvent.VK_K , KeyEvent.VK_L , KeyEvent.VK_M , KeyEvent.VK_N , KeyEvent.VK_O , KeyEvent.VK_P , KeyEvent.VK_Q , KeyEvent.VK_R , KeyEvent.VK_S , KeyEvent.VK_T , KeyEvent.VK_U , KeyEvent.VK_V , KeyEvent.VK_W , KeyEvent.VK_X , KeyEvent.VK_Y , KeyEvent.VK_Z , KeyEvent.VK_LEFT , KeyEvent.VK_RIGHT , KeyEvent.VK_UP , KeyEvent.VK_DOWN };

  String[] Tkeys = new String[] { "A" , "Z" , "Q" , "S" , "W" , "X" , "Right" , "Down" , "Up" , "Left" , "Space" };
  int[] TVkeys = new int[] { KeyEvent.VK_A , KeyEvent.VK_Z , KeyEvent.VK_Q , KeyEvent.VK_S , KeyEvent.VK_W , KeyEvent.VK_X , KeyEvent.VK_RIGHT , KeyEvent.VK_DOWN , KeyEvent.VK_UP , KeyEvent.VK_LEFT , KeyEvent.VK_SPACE };
  final int rotatePlus90Deg_OY = 0;
  final int rotateMoins90Deg_OY = 1;
  final int rotatePlus90Deg_OZ = 2;
  final int rotateMoins90Deg_OZ = 3;
  final int rotatePlus90Deg_OX = 4;
  final int rotateMoins90Deg_OX = 5;
  final int right = 6;
  final int down = 7;
  final int up = 8;
  final int left = 9;
  final int space = 10;

  private Hashtable Hkeys = new Hashtable();
  {
    Hkeys.put( "rotatePlus90Deg_OY" ,
              new Object[] { Tkeys[ 0 ] , "rotatePlus90Deg_OY" , new Integer( XOrgRep + 30 ) , new Integer( YOrgRep - 30 ) ,
              "gPanInst1" , Tkeys[ 0 ] , ">" , new Integer( TVkeys[ 0 ] ) } );
    Hkeys.put( "rotateMoins90Deg_OY" ,
              new Object[] { Tkeys[ 1 ] , "rotateMoins90Deg_OY" , new Integer( XOrgRep - 50 ) , new Integer( YOrgRep - 30 ) ,
              "gPanInst1" , Tkeys[ 1 ] , "<" , new Integer( TVkeys[ 1 ] ) } );
    Hkeys.put( "rotatePlus90Deg_OZ" ,
              new Object[] { Tkeys[ 2 ] , "rotatePlus90Deg_OZ" , new Integer( XOrgRep - 60 ) , new Integer( YOrgRep - 25 ) ,
              "gPanInst3" , Tkeys[ 2 ] , "<" , new Integer( TVkeys[ 2 ] ) } );
    Hkeys.put( "rotateMoins90Deg_OZ" ,
              new Object[] { Tkeys[ 3 ] , "rotateMoins90Deg_OZ" , new Integer( XOrgRep + 20 ) , new Integer( YOrgRep + 40 ) ,
              "gPanInst3" , Tkeys[ 3 ] , "<" , new Integer( TVkeys[ 3 ] ) } );
    Hkeys.put( "rotatePlus90Deg_OX" ,
              new Object[] { Tkeys[ 4 ] , "rotatePlus90Deg_OX" , new Integer( XOrgRep + 20 ) , new Integer( YOrgRep - 30 ) ,
              "gPanInst2" , Tkeys[ 4 ] , "^" , new Integer( TVkeys[ 4 ] ) } );
    Hkeys.put( "rotateMoins90Deg_OX" ,
              new Object[] { Tkeys[ 5 ] , "rotateMoins90Deg_OX" , new Integer( XOrgRep + 20 ) , new Integer( YOrgRep + 30 ) ,
              "gPanInst2" , Tkeys[ 5 ] , "v" , new Integer( TVkeys[ 5 ] ) } );
    Hkeys.put( "Right" ,
              new Object[] { Tkeys[ 6 ] , "right" , new Integer( XOrgRep + longAxes - 15 ) , new Integer( YOrgRep - 10 ) ,
              "gPanInst4" , Tkeys[ 6 ] , "" , new Integer( TVkeys[ 6 ] ) } );
    Hkeys.put( "Down" ,
              new Object[] { Tkeys[ 7 ] , "down" , new Integer( XOrgRep + 10 ) , new Integer( YOrgRep + longAxes ) ,
              "gPanInst4" , Tkeys[ 7 ] , "" , new Integer( TVkeys[ 7 ] ) } );
    Hkeys.put( "Up" ,
              new Object[] { Tkeys[ 8 ] , "up" , new Integer( XOrgRep - 10 ) , new Integer( YOrgRep - longAxes - 10 ) ,
              "gPanInst4" , Tkeys[ 8 ] , "" , new Integer( TVkeys[ 8 ] ) } );
    Hkeys.put( "Left" ,
              new Object[] { Tkeys[ 9 ] , "left" , new Integer( XOrgRep - longAxes - 10 ) , new Integer( YOrgRep - 10 ) ,
              "gPanInst4" , Tkeys[ 9 ] , "" , new Integer( TVkeys[ 9 ] ) } );
    //Hkeys.put( "Space" , new Object[] { Tkeys[ 10 ] , "left" , null , null , "gPanInst4" , Tkeys[ 10 ] , "" } );
  }

  private KeyListener kl = new KeyListener() {
    public void keyTyped( KeyEvent e ) {}
    public void keyReleased( KeyEvent e ) {}
    public void keyPressed(KeyEvent e)
    {
      int code = e.getKeyCode();

      if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotatePlus90Deg_OY" ) )[ 7 ] ).intValue() )
      {
        rotatePlus90Deg_OY( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotateMoins90Deg_OY" ) )[ 7 ] ).intValue() )
      {
        rotateMoins90Deg_OY( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotatePlus90Deg_OZ" ) )[ 7 ] ).intValue() )
      {
        rotatePlus90Deg_OZ( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotateMoins90Deg_OZ" ) )[ 7 ] ).intValue() )
      {
        rotateMoins90Deg_OZ( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotatePlus90Deg_OX" ) )[ 7 ] ).intValue() )
      {
        rotatePlus90Deg_OX( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "rotateMoins90Deg_OX" ) )[ 7 ] ).intValue() )
      {
        rotateMoins90Deg_OX( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "Right" ) )[ 7 ] ).intValue() )
      {
        right( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "Down" ) )[ 7 ] ).intValue() )
      {
        down( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "Up" ) )[ 7 ] ).intValue() )
      {
        up( true );
      } else if ( code == ( ( Integer )( ( Object[] )Hkeys.get( "Left" ) )[ 7 ] ).intValue() )
      {
        left( true );
      } else if ( code == KeyEvent.VK_SPACE )
      {
        if ( ( observeHeapMode == true ) || ( trainingMode == true ) )
        {
          return;
        }
        fall();
      }
    }
  };

  private class klObserveHeap implements KeyListener
  {
    private double a;
    private double cosA;
    private double sinA;

    public klObserveHeap()
    {
      a = 0;
      cosA = Math.PI/16 * Math.cos( a );
      sinA = Math.PI/16 * Math.sin( a );
    }

    public void keyTyped( KeyEvent e ){}

    public void keyPressed( KeyEvent e )
    {

      int code = e.getKeyCode();

      if ( code == KeyEvent.VK_LEFT )
      {
        //GDG3DTetris.this.heapCloned.rotate( 0 , sinA , cosA );
        GDG3DTetris.this.heapCloned.rotate( 0 , sinA , 0 );
        GDG3DTetris.this.heapCloned.rotate( 0 , 0 , cosA );
        GDG3DTetris.this.heapCloned.setCalculateForNewPosition( true );
        erasePan();
        GDG3DTetris.this.heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
      } else if ( code == KeyEvent.VK_RIGHT )
      {
        //GDG3DTetris.this.heapCloned.rotate( 0 , -sinA , -cosA );
        GDG3DTetris.this.heapCloned.rotate( 0 , -sinA , 0 );
        GDG3DTetris.this.heapCloned.rotate( 0 , 0 , -cosA );
        GDG3DTetris.this.heapCloned.setCalculateForNewPosition( true );
        erasePan();
        GDG3DTetris.this.heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
      } else if ( code == KeyEvent.VK_DOWN )
      {
        if ( a >= Math.PI ) a = 0;
        a += Math.PI/16;
        sinA = Math.PI/16 * Math.sin( a );
        cosA = Math.PI/16 * Math.cos( a );
        GDG3DTetris.this.heapCloned.rotate( Math.PI/16 , 0 , 0 );
        GDG3DTetris.this.heapCloned.setCalculateForNewPosition( true );
        erasePan();
        GDG3DTetris.this.heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
      } else if ( code == KeyEvent.VK_UP )
      {
        if ( a <= -Math.PI ) a = 0;
        a -= Math.PI/16;
        sinA = Math.PI/16 * Math.sin( a );
        cosA = Math.PI/16 * Math.cos( a );
        GDG3DTetris.this.heapCloned.rotate( -Math.PI/16 , 0 , 0 );
        GDG3DTetris.this.heapCloned.setCalculateForNewPosition( true );
        erasePan();
        GDG3DTetris.this.heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
      }
    }

    public void keyReleased(KeyEvent e)
    {
    }
  }

  private klObserveHeap kloh;

  //-----------------------------------
  private final String[] buttons = { "newGame" , "pause" , "training" , "observeHeap" , "help" , "saveLoadGame" , "saveLoadKeys" , "quit" };
  private final String[] buttons1 = { "newGame" , "pause" , "training" , "observeHeap" };
  private final String[] buttons2 = { "help" , "saveLoadGame" , "saveLoadKeys" , "quit" };

  private Hashtable Hbuttons = new Hashtable();
  {
    Hbuttons.put( "buttonChangeRotOX" , new Object[] { "Menubutton" , null , "Change Keys" , "Change keys for this rotation." } );
    Hbuttons.put( "buttonChangeRotOY" , new Object[] { "Menubutton" , null , "Change Keys" , "Change keys for this rotation." } );
    Hbuttons.put( "buttonChangeRotOZ" , new Object[] { "Menubutton" , null , "Change Keys" , "Change keys for this rotation." } );
    Hbuttons.put( "buttonChangeDepOXOY" , new Object[] { "Menubutton" , null , "Change Keys" , "Change keys for horizontal deplacements." } );
    Hbuttons.put( "newGame" , new Object[] { "Button" , null , "newGame" , "normal" , "Start New Game" , "New Game" , "To end the actual game and start a new one." } );
    Hbuttons.put( "pause" , new Object[] { "Button" , null , "pause" , "disabled" , "Pause" , "Abort Pause" , "To enter and exit the pause mode." } );
    Hbuttons.put( "training" , new Object[] { "Button" , null , "training" , "normal" , "Training" , "Return To Game" , "To enter and exit the training mode." } );
    Hbuttons.put( "observeHeap" , new Object[] { "Button" , null , "observeHeap" , "normal" , "Around The Heap" , "Return To Game" , "To suspend the game and turn around the heap." } );
    Hbuttons.put( "saveLoadKeys" , new Object[] { "Menubutton" , null , "saveKeys" , "normal" , "Save/Load Keys" , "To save and load new playing keys configuration." } );
    Hbuttons.put( "saveLoadGame" , new Object[] { "Menubutton" , null , "saveGame" , "normal" , "Save/Load Game" , "To save and load new heap." } );
    Hbuttons.put( "help" , new Object[] { "Button" , null , "help" , "normal" , "Help" , "Exit Help" , "To enter and exit the help." } );
    Hbuttons.put( "quit" , new Object[] { "Button" , null , "quit" , "normal" , "Quit" , "To exit the game." } );
  }

  //-----------------------------------
  private static String[] help = {
    "gdg 3D Tetris JAVA 2 / Swing   version,  written by   Georges Dreiding." ,
    " " ,
    "To run the game just type 'java 3DTetris.jar' whith the following \"optional\" options :" ,
    " " ,
    "'-h' to display this help page" ,
    "'-e' for expanded look" ,
    "'-c' for compact look" ,
    "'-k' followed by the name of a file containing keys configuration ( see 'Save / Load Keys' button )" ,
    "'-g' followed by the name of a file containing a game description ( see 'Save / Load Game' button )" ,
    "'-t' followed by the number of minutes after wich the game will high his speed." ,
    " " ,
    "To move the falling form, use the keys specified in the four green pans." ,
    "Press the 'space bar key' to make it fall immediatly." ,
    " " ,
    " " ,
    "Button 'New Game / Start New Game' : ends the current game / start a new game." ,
    "Button 'Pause / Abort Pause' : enter / exit the pause mode." ,
    "Button 'Training / Return To Game' : enter / exit the training mode." ,
    "Button 'Around The Heap / Return To Game' : enter / exit the 'turning around the heap mode'." ,
    "Button 'Save/Load Game' : Save actual heap into a file  or  Load a heap from a file." ,
    "Button 'Save/Load Keys' : Save actuals playing keys into a file  or  Load new playing keys from a" ,
    "file." ,
    "Button 'Quit' : to exit the game." ,
    "The buttons 'Rotation ...' and 'Deplacement'  : to choose new playing keys ( except 'space bar key' )."
};

  //-----------------------------------
  private Hashtable Hmessages = new Hashtable();
  {
    Hmessages.put( "cantUp" , "Can\'t move Up." );
    Hmessages.put( "cantDown" , "Can\'t move Down." );
    Hmessages.put( "cantRight" , "Can\'t move Right." );
    Hmessages.put( "cantLeft" , "Can\'t move Left." );
    Hmessages.put( "cantRotate" , "Can\'t Rotate." );
    String s = (String)( ( Object[] )Hbuttons.get( "pause" ) )[5];
    Hmessages.put( "pauseMode" , "Pause mode : press the \'" + s + "\' button to exit the help mode." );
    s = (String)( ( Object[] )Hbuttons.get( "help" ) )[5];
    Hmessages.put( "helpMode" , "Help mode : press the \'" + s + "\' button to exit the help mode." );
    s = (String)( ( Object[] )Hbuttons.get( "training" ) )[5];
    Hmessages.put( "trainingMode" , "Training mode : press the \'" + s + "\' button to continue the actual game." );
    s = (String)( ( Object[] )Hbuttons.get( "observeHeap" ) )[5];
    Hmessages.put( "observeHeapMode" , "'Turning Around The Heap' Mode : Use the four arrow keys to turn around the heap. Press the \'" + s + "\' button to continue the actual game." );
    Hmessages.put( "noFile" , "File doesn\'t exist." );
    Hmessages.put( "startNewGameMode" , "Press the \'Start New Game\' button to start the new game." );
    Hmessages.put( "newGameMode" , "Press the \'New Game\' button for a new game." );
  }
  private String messInPanNextForme = "";

  private String message = "\n\n\"Tetris-3D Perl/Tk v0\" message :\n\n";

  //-----------------------------------
  private int top = 1000;
  private int topInit = top;
  private int bigTop = 1000 * 60 * 5;

  //-----------------------------------
  private class ButtonListener implements ActionListener
  {
    private Method m;
    private String i;
    private int n;
    private Object target;

    public ButtonListener( String s , String i , int n , Object target )
    {
      this.target = target;
      try
      {
    	this.n = n;
        this.i = i;
        if ( i.equals( "-1" ) )
        {
          m = target.getClass().getMethod( s , null );
        }
        else
        {
          m = target.getClass().getMethod( s , new Class[] { String.class , Integer.class , String.class } );
        }
      }
      catch( Exception e1 )
      {
        System.out.println( "A propos : " + target.getClass().toString() + "    " + s + "  error : " + e1.toString() );
      }
    }
    public void actionPerformed( ActionEvent e )
    {
      changingKeysMode = true;
      try
      {
        if ( i.equals( "-1" ) )
        {
          m.invoke( target , null );
        }
        else
        {
          m.invoke( target , new Object[] { new String( i ) , new Integer( n ) , ( (JMenuItem)e.getSource() ).getText() } );
        }
      }
      catch( Exception e1 )
      {
        System.out.println(  "A propos : " + target.getClass().toString() + "  error in calling Methode " + m.getName() + " with args : " +
        i + "                 " + e1.toString() );
        changingKeysMode = false;
      }
      changingKeysMode = false;
    }
  }

  //-----------------------------------
  private class MenuButtonListener implements ActionListener
  {
    public void actionPerformed( ActionEvent e )
    {
      String t = ( ( JButton )e.getSource() ).getText();
      if ( t.equals( "Save/Load Game" ) )
      {
        JPopupMenu jpm = new JPopupMenu();
        jpm.addPopupMenuListener( new PopupMenuListener() {
          public void popupMenuCanceled( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
          public void popupMenuWillBecomeVisible( PopupMenuEvent e ) { changingKeysMode = true; menuDevelopped = true; }
          public void popupMenuWillBecomeInvisible( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
        } );
        jpm.setRequestFocusEnabled( false );
        JMenuItem jm = new JMenuItem( "Save Game" );
        jm.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        jm.addActionListener( new ButtonListener( "saveGame" , "-1" , -1 , GDG3DTetris.this ) );
        jm.setBackground( Color.orange );
        jm.setRequestFocusEnabled( false );
        jpm.add( jm );
        if ( ( heap == null ) || ( heap.getStages() == null ) || ( ( heap.getStages() )[1] == 0 ) ) jm.setEnabled( false );
        jm = new JMenuItem( "Load Game" );
        jm.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        jm.addActionListener( new ButtonListener( "loadGame" , "-1" , -1 , GDG3DTetris.this ) );
        jm.setBackground( Color.orange );
        jm.setRequestFocusEnabled( false );
        jpm.add( jm );
        if ( look == Expanded )
        {
          jpm.show( panButtons , ( ( JButton )e.getSource() ).getX() , ( ( JButton )e.getSource() ).getY() );
        }
        else
        {
          jpm.show( panButtons2 , ( ( JButton )e.getSource() ).getX() , ( ( JButton )e.getSource() ).getY() );
        }
      } else if ( t.equals( "Save/Load Keys" ) )
      {
        JPopupMenu jpm = new JPopupMenu();
        jpm.addPopupMenuListener( new PopupMenuListener() {
          public void popupMenuCanceled( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
          public void popupMenuWillBecomeVisible( PopupMenuEvent e ) { changingKeysMode = true;  menuDevelopped = true; }
          public void popupMenuWillBecomeInvisible( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
        }
        );
        jpm.setRequestFocusEnabled( false );
        JMenuItem jm = new JMenuItem( "Save Keys" );
        jm.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        jm.addActionListener( new ButtonListener( "saveKeys" , "-1" , -1 , GDG3DTetris.this ) );
        jm.setBackground( Color.orange );
        jm.setRequestFocusEnabled( false );
        jpm.add( jm );
        jm = new JMenuItem( "Load Keys" );
        jm.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        jm.addActionListener( new ButtonListener( "loadKeys" , "-1" , -1 , GDG3DTetris.this ) );
        jm.setBackground( Color.orange );
        jm.setRequestFocusEnabled( false );
        jpm.add( jm );
        if ( look == Expanded )
        {
          jpm.show( panButtons , ( ( JButton )e.getSource() ).getX() , ( ( JButton )e.getSource() ).getY() );
        }
        else
        {
          jpm.show( panButtons2 , ( ( JButton )e.getSource() ).getX() , ( ( JButton )e.getSource() ).getY() );
        }
      } else
      {
        ArrayList l = new ArrayList();
        JPanel pan = null;
        if ( t.equals( "Rotation OY" ) )
        {
          l.add( "Rotate OY >" );
          l.add( "Rotate OY <" );
          pan = panInst1;
        } else if ( t.equals( "Rotation OX" ) )
        {
          l.add( "Rotate OX ^" );
          l.add( "Rotate OX v" );
          pan = panInst2;
        } else if ( t.equals( "Rotation OZ" ) )
        {
          l.add( "Rotate OZ <" );
          l.add( "Rotate OZ >" );
          pan = panInst3;
        } else if ( t.equals( "Deplacement" ) )
        {
          l.add( "Up" );
          l.add( "Down" );
          l.add( "Left" );
          l.add( "Right" );
          pan = panInst4;
        }
        JPopupMenu jpm = new JPopupMenu();
        jpm.addPopupMenuListener( new PopupMenuListener() {
          public void popupMenuCanceled( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
          public void popupMenuWillBecomeVisible( PopupMenuEvent e ) { changingKeysMode = true; menuDevelopped = true; }
          public void popupMenuWillBecomeInvisible( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
        }
        );
        jpm.setRequestFocusEnabled( false );
        ListIterator li = l.listIterator();
        while ( li.hasNext() )
        {
          String tx = (String)li.next();
          JMenuItem jm = new JMenuItem( tx );
          jm.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
          jm.setBackground( Color.orange );
          jm.setRequestFocusEnabled( false );
          jpm.add( jm );
          jm.addActionListener( new ActionListener()
          {
            public void actionPerformed( ActionEvent e )
            {
              JPopupMenu jpm = new JPopupMenu();
              jpm.addPopupMenuListener( new PopupMenuListener() {
                public void popupMenuCanceled( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
                public void popupMenuWillBecomeVisible( PopupMenuEvent e ) { changingKeysMode = true; menuDevelopped = true; }
                public void popupMenuWillBecomeInvisible( PopupMenuEvent e ) { changingKeysMode = false; menuDevelopped = false; }
              } );
              jpm.setRequestFocusEnabled( false );
              String key = "";
              int x = 0 , y = 0;
              if ( look == Expanded )
              {
                y = 125;
              }
              String t = ( (JMenuItem)e.getSource() ).getText();
              if ( t.equals( "Rotate OY >" ) )
              {
                x = XPanInst1;
                key = "rotatePlus90Deg_OY";
              }
              else if ( t.equals( "Rotate OY <" ) )
              {
                x = XPanInst1;
                key = "rotateMoins90Deg_OY";
              }
              else if ( t.equals( "Rotate OX ^" ) )
              {
                x = XPanInst2;
                key = "rotatePlus90Deg_OX";
              }
              else if ( t.equals( "Rotate OX v" ) )
              {
                x = XPanInst2;
                key = "rotateMoins90Deg_OX";
              }
              else if ( t.equals( "Rotate OZ <" ) )
              {
                x = XPanInst3;
                key = "rotatePlus90Deg_OZ";
              }
              else if ( t.equals( "Rotate OZ >" ) )
              {
                x = XPanInst3;
                key = "rotateMoins90Deg_OZ";
              }
              else if ( t.equals( "Up" ) )
              {
                x = XPanInst4;
                key = "Up";
              }
              else if ( t.equals( "Down" ) )
              {
                x = XPanInst4;
                key = "Down";
              }
              else if ( t.equals( "Left" ) )
              {
                x = XPanInst4;
                key = "Left";
              }
              else if ( t.equals( "Right" ) )
              {
                x = XPanInst4;
                key = "Right";
              }
              for ( int i = 0 ; i < tabKeys.length ; i++ )
              {
                JCheckBoxMenuItem jm_i = new JCheckBoxMenuItem( tabKeys[i] );
                jm_i.setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
                jm_i.setRequestFocusEnabled( false );
                if ( ( ( String ) ( ( Object[] )Hkeys.get( key ) )[ 0 ] ).equals( tabKeys[ i ] ) )
                {
                  jm_i.setState( true );
                }
                jm_i.setBackground( Color.orange );
                jm_i.addActionListener( new ButtonListener( "bindKeys" , key , tabVKeys[ i ] , GDG3DTetris.this ) );
                jpm.add( jm_i );
              }
              jpm.show( cp , x , y );
            }
          }
          );
        }
        jpm.show( pan , ( ( JButton )e.getSource() ).getX() , ( ( JButton )e.getSource() ).getY() );
      }
    }
  }

  //---------------------------------------------------------------------------
  public void setOptK( String s )
  {
    opt_k = s;
  }

  //---------------------------------------------------------------------------
  public void setOptG( String s )
  {
    opt_g = s;
  }

  //---------------------------------------------------------------------------
  public String getOptK()
  {
    return opt_k;
  }

  //---------------------------------------------------------------------------
  public String getOptG()
  {
    return opt_g;
  }

  //---------------------------------------------------------------------------
  public void bindKeys( String i , Integer n , String k )
  {
    Object[] t = ( Object[] )Hkeys.get( i );
    t[ 0 ] = k;
    t[ 7 ] = n;
    menuDevelopped = false;
    drawPanInst();
    repaint();
  }

  //---------------------------------------------------------------------------
  private void disableAllButtons( String[] s )
  {
    Object[] t = null;
    f: for ( int i = 0 ; i < buttons.length ; i++ )
    {
      if ( s != null ) for ( int j = 0 ; j < s.length ; j++ ) if ( ( (String) buttons[ i ] ).equals( s[ j ] ) ) continue f;
      ( ( JButton ) ( ( ( Object[] ) Hbuttons.get( buttons[ i ] ) )[ 1 ] ) ).setEnabled( false );
    }
  }

  //---------------------------------------------------------------------------
  private void enableAllButtons( String[] s )
  {
    Object[] t = null;
    f: for ( int i = 0 ; i < buttons.length ; i++ )
    {
      if ( s != null ) for ( int j = 0 ; j < s.length ; j++ ) if ( ( (String) buttons[ i ] ).equals( s[ j ] ) ) continue f;
      ( ( JButton ) ( ( ( Object[] ) Hbuttons.get( buttons[ i ] ) )[ 1 ] ) ).setEnabled( true );
    }
  }

  //---------------------------------------------------------------------------
  public void pause()
  {
    pauseMode = ! pauseMode;
    eraseMsgPartOfPanNextForme();

    Object[] t = ( Object[] )Hbuttons.get( "pause" );

    if ( pauseMode == false )
    {
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );
    }
    else
    {
      affMsgInPanNextForme( (String)Hmessages.get( "pauseMode" ) );
      ( ( JButton )t[ 1 ] ). setEnabled( true );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );
    }
  }

  //---------------------------------------------------------------------------
  public void newGame()
  {
    newGameMode = !newGameMode;

    Object[] t = null;

    if ( newGameMode == false )
    {
      erasePanNextForme();
      messInPanNextForme = "";

      erasePan();
      drawScene();

      drawStages( heap );

      top = topInit;

      t = ( Object[] )Hbuttons.get( "newGame" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );

      if ( pauseMode == true )
      {
        t = ( Object[] )Hbuttons.get( "pause" );
        ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );
        pauseMode = false;
      }
      ( ( JButton ) ( ( ( Object[] ) Hbuttons.get( "pause" ) )[ 1 ] ) ).setEnabled( true );

      return;
    }

    erasePanNextForme();
    messInPanNextForme = (String)( Hmessages.get( "startNewGameMode" ) );
    affMsgInPanNextForme( messInPanNextForme );

    endedGameMode = false;

    heap = null;

    heap = new Volume();

    heap.setCalculateForNewPosition( true );

    heap.setNbStages( GDG3DTetrisCstes.SCENE );

    t = ( Object[] )Hbuttons.get( "newGame" );
    ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );

    ( ( JButton ) ( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( false );

    erasePan();

    drawStages( heap );

    forme = null;

    nextForme = null;

    ( ( JButton ) ( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );

    drawSceneHeapForme();

  }

  //---------------------------------------------------------------------------
  boolean wasPauseMode;
  public void training()
  {
    erasePan();

    Object[] t = null;

    if ( trainingMode == true )
    {
      trainingMode = false;
      pauseMode = wasPauseMode;

      scene = scenePlaying;

      scaleX = scaleXPlaying;
      scaleY = scaleYPlaying;

      obsX = obsXPlaying;
      obsY = obsYPlaying;
      obsZ = obsZPlaying;

      offsetX = offsetXPlaying;
      offsetY = offsetYPlaying;

      forme = formeBuff;
      formeBuff = null;

      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( true );

      messInPanNextForme = "";

      if ( ( endedGameMode == false ) && ( newGameMode == true ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      }
      else if ( ( endedGameMode == true ) && ( newGameMode == false ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      }
      else
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( true );
      }

      erasePanNextForme();

      if ( ( newGameMode == false ) && ( endedGameMode == true ) )
      {
        messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

      if ( newGameMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "startNewGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

      if ( pauseMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "pauseMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

      t = ( Object[] )Hbuttons.get( "training" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );

      if ( ( heap != null ) && ( heap.getStages() != null ) && ( ( heap.getStages() )[1] != 0 ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
      }

      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadKeys" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) )[ 1 ] ).setEnabled( true );

      drawSceneHeapForme();
      drawNextForme();

    }
    else
    {
      trainingMode = true;
      wasPauseMode = pauseMode;
      pauseMode = false;

      scene = sceneTraining;

      formeBuff = forme;
      forme = formeTraining;

      scaleX = scaleXTraining;
      scaleY = scaleYTraining;

      obsX = obsXTraining;
      obsY = obsYTraining;
      obsZ = obsZTraining;

      offsetX = offsetXTraining;
      offsetY = offsetYTraining;

      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( false );

      t = ( Object[] )Hbuttons.get( "training" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );

      erasePanNextForme();

      drawSceneHeapForme();

      drawStages( heap );

      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "trainingMode" ) );
      affMsgInPanNextForme( messInPanNextForme );
    }
  }

  //---------------------------------------------------------------------------
  public void observeHeap()
  {
    erasePan();

    Object[] t = null;

    if ( observeHeapMode == false )
    {
      observeHeapMode = true;

      removeKeyListener( kl );

      kloh = new klObserveHeap();
      addKeyListener( kloh );

      heapCloned = new Volume( heap );

      t = ( Object[] )Hbuttons.get( "observeHeap" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );

      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "help" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "training" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadKeys" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) )[ 1 ] ).setEnabled( false );

      heapCloned.setCalculateForNewPosition( true );

      erasePanNextForme();

      heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );

      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "observeHeapMode" ) );
      affMsgInPanNextForme( messInPanNextForme );
    }
    else
    {
      observeHeapMode = false;

      if ( ( endedGameMode == true ) && ( newGameMode == false ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      }
      else
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( true );
      }

      t = ( Object[] )Hbuttons.get( "observeHeap" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );

      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "help" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "training" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadKeys" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) )[ 1 ] ).setEnabled( true );

      erasePan();

      drawSceneHeapForme();

      erasePanNextForme();

      drawNextForme();

      removeKeyListener( kloh );
      kloh = null;

      addKeyListener( kl );

      heapCloned = null;

      messInPanNextForme = "";

      if ( ( newGameMode == false ) && ( endedGameMode == true ) )
      {
        messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

      if ( newGameMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

      if ( pauseMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "pauseMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }
    }
  }

  //---------------------------------------------------------------------------
  public void help()
  {

    helpMode = ! helpMode;

    erasePan();

    Object[] t = null;

    if ( helpMode == true )
    {
      ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "training" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadKeys" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) )[ 1 ] ).setEnabled( false );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) )[ 1 ] ).setEnabled( false );

      t = ( Object[] )Hbuttons.get( "help" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );

      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "helpMode" ) );
      affMsgInPanNextForme( messInPanNextForme );

      erasePan();
      affMsgInPan( help );

    }
    else
    {
      messInPanNextForme = "";

      t = ( Object[] )Hbuttons.get( "help" );
      ( ( JButton )t[ 1 ] ).setText( (String)t[ 4 ] );

      if ( trainingMode == false )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "newGame" ) )[ 1 ] ).setEnabled( true );
        ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadGame" ) )[ 1 ] ).setEnabled( true );
      }

      if ( ( endedGameMode == false ) && ( newGameMode == true ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      }
      else if ( ( endedGameMode == true ) && ( newGameMode == false ) )
      {
        ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      }
      else
      {
        if ( trainingMode == false )
        {
          ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( true );
        }
      }

      ( ( JButton )( ( Object[] )Hbuttons.get( "training" ) )[ 1 ] ).setEnabled( true );

      if ( trainingMode == false )
      {
        if ( ( heap != null ) && ( heap.getStages() != null ) && ( ( heap.getStages() )[1] != 0 ) )
        {
          ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
        }
      }

      ( ( JButton )( ( Object[] )Hbuttons.get( "saveLoadKeys" ) )[ 1 ] ).setEnabled( true );

      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) )[ 1 ] ).setEnabled( true );
      ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) )[ 1 ] ).setEnabled( true );

      erasePanNextForme();

      drawSceneHeapForme();

      if ( ( newGameMode == false ) && ( endedGameMode == true ) )
      {
        messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
        return;
      }

      if ( newGameMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "startNewGameMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
        return;
      }

      if ( trainingMode == true )
      {
        messInPanNextForme = (String)( Hmessages.get( "trainingMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
        return;
      }

      if ( pauseMode == true )
      {
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "pauseMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
        return;
      }

      drawNextForme();

    }
  }

  //---------------------------------------------------------------------------
  private void calcSumFile( File f )
  {
    File ff = null;

    DataInputStream dis = null;
    long s = 0;
    try
    {
      dis = new DataInputStream( new FileInputStream( f ) );
      dis.mark( (int)f.length() );
      String l = null;
      while ( true )
      {
        s = s + dis.readByte();
      }
    }
    catch ( EOFException e )
    {
      try{ dis.close(); } catch(Exception ex) {}
    }
    catch ( java.io.IOException e )
    {
      System.out.println( e.toString() );
    }

    BufferedReader br = null;
    BufferedWriter br_ = null;
    File f_ = new File( f.getName() + "_" );
    try
    {
      br = new BufferedReader( new FileReader( f ) );
      br_ = new BufferedWriter( new FileWriter( f_ ) );
      br_.write( Long.toString( s ) );
      String l = null;
      br_.write( "\r\n" );
      while ( ( l = br.readLine() ) != null )
      {
        br_.write( l + "\r\n" );
      }
    }
    catch ( EOFException e )
    {
    }
    catch ( java.io.IOException e )
    {
      System.out.println( e.toString() );
    }
    finally
    {
      try{ br.close(); } catch(Exception e){}
      try{ br_.close(); } catch(Exception e){}
    }

    f.delete();
    f_.renameTo( f );

  }

  //---------------------------------------------------------------------------
  private boolean checkFile( File f )
  {
    File f_ = new File( f.getName() + "_" );

    if ( f_.exists() )
    {
      if ( f.exists() )
      {
        f.delete();
      }
      f_.renameTo( f );
    }

    if ( !( f.exists() ) ) return true;

    DataInputStream dis = null;
    long s = 0 , sRef = 0;
    try
    {
      dis = new DataInputStream( new FileInputStream( f ) );
      BufferedReader br = new BufferedReader( new FileReader( f ) );
      String l = br.readLine();
      sRef = Long.parseLong( l );
      dis.read( new byte[ l.length() + "\r\n".length() ] );
      while ( true )
      {
        s = s + dis.readByte();
      }
    }
    catch ( EOFException e )
    {
      try{ dis.reset(); } catch(Exception ex) {}
    }
    catch ( java.io.IOException e )
    {
      System.out.println( e.toString() );
    }

    return ( sRef == s );
  }

  //---------------------------------------------------------------------------
  public void quit()
  {
    System.exit( 0 );
  }

  //---------------------------------------------------------------------------
  public void saveGame()
  {
    eraseMsgPartOfPanNextForme();

    changingGameMode = true;

    File f = null;

    JFileChooser jfc = new JFileChooser();
    jfc.setCurrentDirectory( new File( ".\\" ) );
    jfc.setMultiSelectionEnabled(false);
    javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter() {
      public boolean accept( File f )
      {
        if ( f.isDirectory() ) return true;
        if ( f.getName().lastIndexOf( ".3DTetG" ) > 0 ) return true;
        return false;
      }
      public String getDescription()
      {
        return "3DTetG 3DTetris Game.";
      }
    };
    jfc.addChoosableFileFilter( ff );
    jfc.setFileFilter( ff );
    int option = jfc.showSaveDialog( this );
    if ( option == JFileChooser.APPROVE_OPTION )
    {
      f = jfc.getSelectedFile();
    }
    else
    {
      changingGameMode = false;
      erasePan();
      drawSceneHeapForme();
      return;
    }

    if ( f.getName().lastIndexOf( ".3DTetG" ) <= 0 )
    {
      f = new File( f.getName() + ".3DTetG" );
    }

    if ( f.exists() )
    {
      int rep = JOptionPane.showConfirmDialog( this , "Write over file " + f.getName() , gameTitle , JOptionPane.YES_NO_CANCEL_OPTION );
      if ( rep != JOptionPane.OK_OPTION )
      {
        changingGameMode = false;
        erasePan();
        drawSceneHeapForme();
        return;
      }
      if ( ! f.canWrite() )
      {
        JOptionPane.showMessageDialog( this , "Can't write over " + f.getName() , gameTitle , JOptionPane.ERROR_MESSAGE );
        changingGameMode = false;
        erasePan();
        drawSceneHeapForme();
        return;
      }
    }

    FileOutputStream fo = null;
    try
    {
      fo = new FileOutputStream( f );
      ObjectOutputStream out = new ObjectOutputStream( fo );
      out.writeObject( heap );
    }
    catch ( Exception e )
    {
      System.out.println( e.toString() );
    }
    finally
    {
      try{ fo.close(); } catch(Exception e){}
    }

    erasePan();
    drawSceneHeapForme();

    changingGameMode = false;

  }

  //---------------------------------------------------------------------------
  public void loadGame()
  {
    eraseMsgPartOfPanNextForme();
    changingGameMode = true;

    // disableAllButtons();

    File f = null;
    if ( ( opt_g != null ) && ( !opt_g.equals( "" ) ) )
    {
      f = new File( opt_g );
      if ( !f.exists() )
      {
        System.out.println( "File " + opt_g + " doesn't exist !" );
        System.exit( 1 );
      }
    }
    else
    {
      JFileChooser jfc = new JFileChooser();
      jfc.setCurrentDirectory( new File( ".\\" ) );
      jfc.setMultiSelectionEnabled(false);
      javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter() {
        public boolean accept( File f )
        {
          if ( f.isDirectory() ) { repaint(); return true; }
          if ( f.getName().lastIndexOf( ".3DTetG" ) > 0 ) { repaint(); return true; }
          //repaint();
          return false;
        }
        public String getDescription()
        {
          //repaint();
          return "3DTetG 3DTetris Game configuration.";
        }
      };
      jfc.addChoosableFileFilter( ff );
      jfc.setFileFilter( ff );
      int option = jfc.showOpenDialog( this );
      if ( option == JFileChooser.APPROVE_OPTION )
      {
        f = jfc.getSelectedFile();
      }
      else
      {
        changingGameMode = false;
        drawSceneHeapForme();
        return;
      }
      jfc.setVisible( false );
    }

    opt_g = null;

    if ( f.getName().lastIndexOf( ".3DTetG" ) <= 0 )
    {
      f = new File( f.getName() + ".3DTetG" );
    }

    heap = null;

    FileInputStream fi = null;
    try
    {
      fi = new FileInputStream( f );
      ObjectInputStream in = new ObjectInputStream( fi );
      heap = (Volume)in.readObject();
    }
    catch ( Exception e )
    {
      System.out.println( e.toString() );
    }
    finally
    {
      try{ fi.close(); } catch(Exception e){}
    }

    heap.setCalculateForNewPosition( true );

    heap.setFill();

    if ( ( forme != null ) && ( heap.intersect( forme ) == true ) )
    {
      forme = null;
    }

    drawSceneHeapForme();

    pauseMode = false;

    newGameMode = false;

    Object[] t = ( Object[] )Hbuttons.get( "newGame" );
    ( ( JButton )t[ 1 ] ).setText( (String)t[ 5 ] );

    ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );

    changingGameMode = false;

    top = topInit;

    if ( ( heap.getStages() == null ) || ( ( (int[] )heap.getStages() )[ heap.getNbStages() - 1 ] != 0 ) )
    {
      endedGameMode = true;
      newGameMode = false;
      ( ( JButton )( ( Object[] )Hbuttons.get( "pause" ) )[ 1 ] ).setEnabled( false );
      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
      affMsgInPanNextForme( messInPanNextForme );

      forme = null;
      nextForme = null;
    }
    else
    {
      pause();
    }

    drawSceneHeapForme();
    drawStages( heap );
    repaint();

  }

  //---------------------------------------------------------------------------
  public void saveKeys()
  {
    eraseMsgPartOfPanNextForme();
    changingKeysMode = true;

    File f = null;

    JFileChooser jfc = new JFileChooser();
    jfc.setCurrentDirectory( new File( ".\\" ) );
    jfc.setMultiSelectionEnabled(false);
    javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter() {
      public boolean accept( File f )
      {
        if ( f.isDirectory() ) return true;
        if ( f.getName().lastIndexOf( ".3DTetK" ) > 0 ) return true;
        return false;
      }
      public String getDescription()
      {
        return "3DTetK 3DTetris keys configuration.";
      }
    };
    jfc.addChoosableFileFilter( ff );
    jfc.setFileFilter( ff );
    int option = jfc.showSaveDialog( this );
    if ( option == JFileChooser.APPROVE_OPTION )
    {
      f = jfc.getSelectedFile();
    }
    else
    {
      changingKeysMode = false;
      return;
    }

    if ( f.getName().lastIndexOf( ".3DTetK" ) <= 0 )
    {
      f = new File( f.getName() + ".3DTetK" );
    }

    if ( f.exists() )
    {
      int rep = JOptionPane.showConfirmDialog( this , "Write over file " + f.getName() , gameTitle , JOptionPane.YES_NO_CANCEL_OPTION );
      if ( rep != JOptionPane.OK_OPTION )
      {
        changingKeysMode = false;
        erasePan();
        drawSceneHeapForme();
        return;
      }
      if ( ! f.canWrite() )
      {
        JOptionPane.showMessageDialog( this , "Can't write over " + f.getName() , gameTitle , JOptionPane.ERROR_MESSAGE );
        changingKeysMode = false;
        erasePan();
        drawSceneHeapForme();
        return;
      }
    }

    if ( f.getName().lastIndexOf( ".3DTetK" ) <= 0 )
    {
      f = new File( f.getName() + ".3DTetK" );
    }

    DataOutputStream dos = null;
    try
    {
      dos = new DataOutputStream( new FileOutputStream( f ) );
      for ( int i = 0 ; i < Tkeys.length ; i++ )
      {
        dos.writeBytes( Tkeys[ i ] + "\r\n" );
      }
    }
    catch ( Exception e )
    {
      System.out.println( e.toString() );
    }
    finally
    {
      try{ dos.close(); } catch(Exception e){}
    }

    calcSumFile( f );

    erasePan();
    drawSceneHeapForme();

    changingKeysMode = false;

  }

  //---------------------------------------------------------------------------
  public void loadKeys()
  {
    changingKeysMode = true;

    File f = null;

    if ( ( opt_k != null ) && ( !opt_k.equals( "" ) ) )
    {
      f = new File( opt_k );
      if ( !f.exists() )
      {
        System.out.println( "File " + opt_k + " doesn't exist !" );
        System.exit( 1 );
      }
    }
    else
    {
      eraseMsgPartOfPanNextForme();

      JFileChooser jfc = new JFileChooser();
      jfc.setCurrentDirectory( new File( ".\\" ) );
      jfc.setMultiSelectionEnabled(false);
      javax.swing.filechooser.FileFilter ff = new javax.swing.filechooser.FileFilter() {
        public boolean accept( File f )
        {
          if ( f.isDirectory() ) return true;
          if ( f.getName().lastIndexOf( ".3DTetK" ) > 0 ) return true;
          return false;
        }
        public String getDescription()
        {
          return "3DTetK 3DTetris keys configuration.";
        }
      };
      jfc.addChoosableFileFilter( ff );
      jfc.setFileFilter( ff );
      int option = jfc.showOpenDialog( this );
      if ( option == JFileChooser.APPROVE_OPTION )
      {
        f = jfc.getSelectedFile();
      }
      else
      {
        changingKeysMode = false;
        erasePan();
        drawSceneHeapForme();
        return;
      }
    }

    if ( f.getName().lastIndexOf( ".3DTetK" ) <= 0 )
    {
      f = new File( f.getName() + ".3DTetK" );
    }

    if ( ! checkFile( f ) )
    {
      if ( opt_k != null )
      {
        System.out.println( "File " + f.getName() + " corrupted !" );
        System.exit( 1 );
      }
      JOptionPane.showMessageDialog( this , "File " + f.getName() + " corrupted !" , gameTitle , JOptionPane.ERROR_MESSAGE );
      changingKeysMode = false;
      erasePan();
      drawSceneHeapForme();
      return;
    }

    opt_k = null;

    BufferedReader br = null;
    try
    {
      br = new BufferedReader( new FileReader( f ) );
      String l = null;
      int i = 0;
      br.readLine();
      while ( ( l = br.readLine() ) != null )
      {
        Tkeys[i++] = l;
      }
    }
    catch( Exception e )
    {
      System.out.println( e.toString() );
    }
    finally
    {
      try{ br.close(); } catch(Exception e){}
    }

    if ( opt_k != null )
    {
      erasePan();
      drawSceneHeapForme();
    }

    changingKeysMode = false;

  }

  //---------------------------------------------------------------------------
  public void displayKeyBinded()
  {
    Enumeration e = Hkeys.keys();
    while ( e.hasMoreElements() )
    {
      Object[] t = ( Object[] )Hkeys.get( e.nextElement() );
      Field gr = null;
      Method m = null;
      try
      {
        gr = this.getClass().getField( (String)t[4] );
        m = gr.getType().getMethod( "drawString" , new Class[] { String.class , int.class , int.class } );
        m.invoke( gr.get( this ) , new Object[] { ( (String)t[0] ).toUpperCase() + (String)t[6] , (Integer)t[2] , (Integer)t[3] } );
      }
      catch ( Exception ex )
      {
        System.out.println( ex.toString() );
      }
    }
  }

  //---------------------------------------------------------------------------
  private void drawRep( Graphics g )
  {
    g.setColor( Color.black );
    g.drawLine( XOrgRep , YOrgRep , XOrgRep , YOrgRep - longAxes );
    g.drawLine( XOrgRep - 5 , YOrgRep - longAxes + 5 , XOrgRep , YOrgRep - longAxes );
    g.drawLine( XOrgRep + 5 , YOrgRep - longAxes + 5 , XOrgRep , YOrgRep - longAxes );
    g.drawLine( XOrgRep , YOrgRep , XOrgRep + longAxes , YOrgRep );
    g.drawLine( XOrgRep + longAxes - 5 , YOrgRep - 5 , XOrgRep + longAxes , YOrgRep );
    g.drawLine( XOrgRep + longAxes - 5 , YOrgRep + 5 , XOrgRep + longAxes , YOrgRep );
    g.drawLine( XOrgRep , YOrgRep , XOrgRep - 30 , YOrgRep + 30 );
    g.drawLine( XOrgRep - 26 , YOrgRep + 20 , XOrgRep - 30 , YOrgRep + 30 );
    g.drawLine( XOrgRep - 20 , YOrgRep + 27 , XOrgRep - 30 , YOrgRep + 30 );
  }

  //---------------------------------------------------------------------------
  private void drawPanInst()
  {
    erasePanInst();

    drawRep( gPanInst1 );
    gPanInst1.setColor( Color.red );
    gPanInst1.drawOval( XOrgRep - longAxes , YOrgRep - longAxes - 10 , longAxes * 2 , (int)( longAxes / 2.5 ) );
    gPanInst1.setColor( Color.black );
    drawRep( gPanInst2 );
    gPanInst2.setColor( Color.red );
    gPanInst2.drawOval( XOrgRep + longAxes - 12 , YOrgRep - longAxes , (int)( longAxes / 2.5 ) , longAxes * 2 );
    gPanInst2.setColor( Color.black );
    drawRep( gPanInst3 );
    gPanInst3.setColor( Color.red );
    gPanInst3.drawOval( XOrgRep - 60 , YOrgRep - 20 , (int)( longAxes * 1.5 ) , (int)( longAxes * 1.5 ) );
    gPanInst3.setColor( Color.black );

    gPanInst4.setColor( Color.black );
    gPanInst4.drawLine( XOrgRep , YOrgRep , XOrgRep , YOrgRep - longAxes );
    gPanInst4.drawLine( XOrgRep - 5 , YOrgRep - longAxes + 5 , XOrgRep , YOrgRep - longAxes );
    gPanInst4.drawLine( XOrgRep + 5 , YOrgRep - longAxes + 5 , XOrgRep , YOrgRep - longAxes );
    gPanInst4.drawLine( XOrgRep , YOrgRep , XOrgRep + longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep + longAxes - 5 , YOrgRep - 5 , XOrgRep + longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep + longAxes - 5 , YOrgRep + 5 , XOrgRep + longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep , YOrgRep , XOrgRep - longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep - longAxes + 5 , YOrgRep - 5 , XOrgRep - longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep - longAxes + 5 , YOrgRep + 5 , XOrgRep - longAxes , YOrgRep );
    gPanInst4.drawLine( XOrgRep , YOrgRep , XOrgRep , YOrgRep + longAxes );
    gPanInst4.drawLine( XOrgRep - 5 , YOrgRep + longAxes - 5 , XOrgRep , YOrgRep + longAxes );
    gPanInst4.drawLine( XOrgRep + 5 , YOrgRep + longAxes - 5 , XOrgRep , YOrgRep + longAxes );
    gPanInst1.setColor( Color.black );

    displayKeyBinded();

  }

  //---------------------------------------------------------------------------
  private void drawStages( Volume v )
  {
    if ( look == GDG3DTetrisCstes.Compact ) return;

    if ( v == null ) return;

    erasePanStages();

    int t = 0 , y = 0 , yl = 0 , x = XPanStages + 5;

    int nbStages = v.getNbStages();
    int[] stages = v.getStages();
    int nbPerStages = v.getNbPerStages();

    int a = heightPanStages / ( nbStages + 1 );
    int aa = a / 2;

    String buff;

    buff = nbPerStages + " per stage";

    gPanStages.setColor( Color.black );

    gPanStages.drawString( buff , XPanStages - 10 , 20 );

    Insets ins = panStages.getInsets();

    for ( int i = 0 ; i < nbStages ; i++ )
    {
      t = stages[ i ];
      if ( i != 0 )
      {
        yl = a * i + 30;
        gPanStages.drawLine( ins.left , yl , widthPanStages - ins.right * 2 , yl );
      }
      if ( t == 0 ) continue;
      y = heightPanStages - a * i + 15;
      buff = t + " on " + nbPerStages;
      gPanStages.drawString( buff , x , y );
    }

  }

  //---------------------------------------------------------------------------
  void bigTopPulse()
  {
    if ( ( trainingMode == true ) || ( pauseMode == true ) || ( changingKeysMode == true ) || ( changingGameMode == true ) ||
    ( newGameMode == true ) || ( endedGameMode == true ) || ( helpMode == true ) || ( observeHeapMode == true ) ) return;

    if ( top > 300 ) top -= 100;

    flotTop.cancel();
    flotTop = new TimerTask() {
      public void run()
      {
        pulse();
      }
    };
    timerTop = new java.util.Timer();
    timerTop.schedule( flotTop , 0 , top );
  }

  //---------------------------------------------------------------------------
  private void pulse()
  {
    //-----------------------------
    if ( ( menuDevelopped == true ) || ( observeHeapMode == true ) || ( helpMode == true ) )
    {
      return;
    }

    //-----------------------------
    if ( pauseMode == true )
    {
      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "pauseMode" ) );
      affMsgInPanNextForme( messInPanNextForme );
      return;
    }

    //-----------------------------
    if ( ( formeOnMove == true ) || ( trainingMode == true ) || ( changingKeysMode == true ) || ( changingGameMode == true ) ||
    ( newGameMode == true ) || ( endedGameMode == true ) )
    {
            return;
    }

    formeOnMove = true;

    //-----------------------------
    eraseMsgPartOfPanNextForme();
    messInPanNextForme = "";

    //-----------------------------
    drawForme();
    //drawNextForme();

    //-----------------------------
    if ( forme == null )
    {
      if ( nextForme == null )
      {
        nextForme = new Volume( GDG3DTetrisCstes.FORMES[ rand.nextInt( GDG3DTetrisCstes.FORMES.length ) ] ,
                            GDG3DTetrisCstes.COLORS_FORMES[ rand.nextInt( GDG3DTetrisCstes.COLORS_FORMES.length ) ] , false , false );
      }

      forme = nextForme;

      nextForme = new Volume( GDG3DTetrisCstes.FORMES[ rand.nextInt( GDG3DTetrisCstes.FORMES.length ) ] ,
                          GDG3DTetrisCstes.COLORS_FORMES[ rand.nextInt( GDG3DTetrisCstes.COLORS_FORMES.length ) ] , false , false );

      nextForme.setCalculateForNewPosition( true );

      nextForme.recentMiddle();

      nextForme.setFill();

      forme.setCalculateForNewPosition( true );

      forme.unSetFill();

      erasePanNextForme();
      drawNextForme();

      forme.recentMiddle();

      Point scenePXminYminZmin = scene.getPXminYminZmin();
      Point scenePXmaxYmaxZmax = scene.getPXmaxYmaxZmax();
      Point formePXminYminZmin = forme.getPXminYminZmin();
      Point formePXmaxYmaxZmax = forme.getPXmaxYmaxZmax();

      forme.translate(
        scenePXminYminZmin.getX() - formePXminYminZmin.getX() +
        rand.nextInt( (int)( ( scenePXmaxYmaxZmax.getX() - formePXmaxYmaxZmax.getX() ) / GDG3DTetrisCstes.COTE_CARRE ) ) * GDG3DTetrisCstes.COTE_CARRE ,
        scenePXminYminZmin.getY() - formePXminYminZmin.getY() + rand.nextInt( (int)( ( scenePXmaxYmaxZmax.getY() - formePXmaxYmaxZmax.getY() ) / GDG3DTetrisCstes.COTE_CARRE ) ) * GDG3DTetrisCstes.COTE_CARRE ,
        scenePXminYminZmin.getZ() - formePXminYminZmin.getZ() );

      //drawForme();

      switch ( rand.nextInt( 3 ) )
      {
        case 0 :
          rotateMoins90Deg_OX( false );
          break;
        case 1 :
          rotateMoins90Deg_OY( false );
          break;
        case 2 :
          rotateMoins90Deg_OZ( false );
          break;
      }

      drawForme();

      formeOnMove = false;

      return;

    }

    //-----------------------------
    Object[] t = null;
    synchronized( forme )
    {
      if ( forme != null )
      {
        forme.translateZPlusOneUnit();

        if ( heap.intersect( forme ) == true )
        {
          forme.translateZMinusOneUnit();

          if ( heap.insertVolume( forme ) == false )
          {
            newGameMode = false;
            endedGameMode = true;
            messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
            affMsgInPanNextForme( messInPanNextForme );
          }
          drawStages( heap );
          ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
          heap.setCalculateForNewPosition( true );
          heap.setFill();
          //erasePanNextForme();
          erasePan();
          scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          forme = null;
          formeOnMove = false;
          return;
        }

        if ( scene.isVolumeAllInside( forme ) == false )
        {
          forme.translateZMinusOneUnit();
          if ( heap.insertVolume( forme ) == false )
          {
            newGameMode = false;
            endedGameMode = true;
            messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
            affMsgInPanNextForme( messInPanNextForme );
          }
          drawStages( heap );
          ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
          heap.setCalculateForNewPosition( true );
          heap.setFill();
          //erasePanNextForme();
          erasePan();
          scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          forme = null;
        }
      }

      drawForme();
    }
    formeOnMove = false;
  }

  //---------------------------------------------------------------------------
  public GDG3DTetris( float opt_t , String opt_k , String opt_g ) {
    super();

    //---------------------------------
    if ( look == Compact )
    {
      heightPan = (int)sizeY ; widthPan = (int)sizeX ;

      heightPanStages = (int)sizeY ; widthPanStages = 100 ; XPanStages = offsetPan ; YPanStages = offsetPan;

      XPanInst = ( widthPan + widthPanStages + offsetPan ) / 4;

      widthPanInst = ( widthPan + widthPanStages + offsetPan ) / 4;

      heightPanButtons = heightPan / 4 ; widthPanButtons = widthPanStages ; XPanButtons = XPanStages ; YPanButtons = offsetPan * 2 + heightPan / 3;

      heightPanInst2 = heightPan / 3 ; widthPanInst2 = widthPanInst ; XPanInst2 = XPanButtons ; YPanInst2 = YPanButtons + heightPanButtons + offsetPan;

      heightPanButtons2 = heightPan / 4 ; widthPanButtons2 = widthPanStages ; XPanButtons2 = offsetPan * 3 + widthPan + widthPanInst1 * 2 - widthPanButtons2 ; YPanButtons2 = offsetPan * 2 + heightPanInst2;

      heightPanInst1 = heightPan / 3 ; widthPanInst1 = widthPanInst ; XPanInst1 = XPanButtons ; YPanInst1 = offsetPan;

      XPan = widthPanInst1 + offsetPan * 2 ; YPan = YPanStages;

      heightPanNextForme = heightPan / 4 ; widthPanNextForme = widthPan ; XPanNextForme = XPan ; YPanNextForme = YPan + offsetPan + heightPan;

      heightPanInst3 = heightPan / 3 ; widthPanInst3 = widthPanInst ; XPanInst3 = XPan + widthPan + offsetPan ; YPanInst3 = YPan;

      heightPanInst4 = heightPan / 3 ; widthPanInst4 = widthPanInst ; XPanInst4 = XPan + widthPan + offsetPan ; YPanInst4 = YPanButtons + heightPanButtons + offsetPan;
    }

    //---------------------------------
    this.opt_k = opt_k;
    this.opt_g = opt_g;
    this.opt_t = opt_t;

    if ( opt_t != 0 )
    {
            bigTop = ( int )( 1000 * 60 * opt_t );
    }
    else
    {
            bigTop = 1000 * 60 * 5;
    }

    if ( ( opt_k != null ) && ( !opt_k.equals( "" ) ) )
    {
      loadKeys();
    }

    //---------------------------------
    forme = null;

    //---------------------------------
    if ( look == Expanded )
    {
      setSize( ( offsetPan * 3 + widthPan + widthPanStages ) ,
               ( offsetPan * 5 + heightPan + heightPanNextForme + heightPanInst1 ) );
    }
    else
    {
      setSize( ( offsetPan * 4 + widthPan + widthPanInst * 2 ) ,
               ( offsetPan * 4 + heightPan + heightPanNextForme ) );
    }

    setResizable( false );

    //---------------------------------
    cp = (JPanel)getContentPane();
    cp.setLayout( null );

    setTitle( gameTitle );

    cp.setBackground( Color.blue );
    cp.setBackground( new Color( 0 , 0 , 0xCC ) );

    //---------------------------------
    if ( look == GDG3DTetrisCstes.Expanded )
    {
      panStages = new JPanel();
      panStages.setBackground( Color.cyan );
      panStages.setDoubleBuffered( true );
      panStages.setBorder( new EtchedBorder( EtchedBorder.RAISED , Color.white , Color.black ) );
    }

    pan = new JPanel();
    pan.setBackground( Color.black );
    pan.setDoubleBuffered( true );

    panNextForme = new JPanel();
    panNextForme.setBackground( Color.black );
    panNextForme.setDoubleBuffered( true );
    panNextForme.setBorder( new EtchedBorder( EtchedBorder.RAISED , Color.white , Color.black ) );

    panButtons = new JPanel();
    panButtons.setBackground( Color.yellow );
    panButtons.setDoubleBuffered( true );

    if ( look == GDG3DTetrisCstes.Compact )
    {
      panButtons2 = new JPanel();
      panButtons2.setBackground( Color.yellow );
      panButtons2.setDoubleBuffered( true );
    }

    panInst1 = new JPanel();
    panInst1.setBackground( Color.green );
    panInst1.setForeground( Color.black );
    panInst1.setDoubleBuffered( true );
    EtchedBorder eb = new EtchedBorder( EtchedBorder.RAISED , Color.white , Color.black );
    panInst1.setBorder( eb );

    panInst2 = new JPanel();
    panInst2.setBackground( Color.green );
    panInst2.setDoubleBuffered( true );
    panInst2.setBorder( eb );

    panInst3 = new JPanel();
    panInst3.setBackground( Color.green );
    panInst3.setDoubleBuffered( true );
    panInst3.setBorder( eb );

    panInst4 = new JPanel();
    panInst4.setBackground( Color.green );
    panInst4.setDoubleBuffered( true );
    panInst4.setBorder( eb );

    //---------------------------------
    if ( look == GDG3DTetrisCstes.Expanded ) panStages.setVisible( true );
    pan.setVisible( true );
    panNextForme.setVisible( true );
    panInst1.setVisible( true );
    panInst2.setVisible( true );
    panInst3.setVisible( true );
    panInst4.setVisible( true );

    //---------------------------------
    panButtons.setOpaque( false );
    if ( look == GDG3DTetrisCstes.Compact ) panButtons2.setOpaque( false );

    //---------------------------------
    if ( look == GDG3DTetrisCstes.Expanded ) cp.add( panStages );
    cp.add( pan );
    cp.add( panButtons );
    if ( look == GDG3DTetrisCstes.Compact ) cp.add( panButtons2 );
    cp.add( panNextForme );
    cp.add( panInst1 );
    cp.add( panInst2 );
    cp.add( panInst3 );
    cp.add( panInst4 );

    //---------------------------------
    Object[] t = null;
    MenuButtonListener mbl = new MenuButtonListener();
    if ( look == GDG3DTetrisCstes.Expanded )
    {
      panButtons.setLayout( new GridLayout( 0 , 1 ) );
      for ( int i = 0 ; i < buttons.length ; i++ )
      {
        t = ( Object[] )Hbuttons.get( buttons[ i ] );
        t[1] = new JButton( (String)t[4] );
        ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
        ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
        ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
        if ( ( (String)( t[0] ) ).equals( "Button" ) )
        {
          ( ( JButton )t[1] ).addActionListener( new ButtonListener( (String)t[2] , "-1" , - 1 , this ) );
        }
        else if ( ( (String)( t[0] ) ).equals( "Menubutton" ) )
        {
          ( ( JButton )t[1] ).addActionListener( mbl );
        }
        ( ( JButton )t[1] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        panButtons.add( ( JButton )t[1] );
        if ( ( (String)t[3] ).equals( "disabled" ) )
        {
          ( ( JButton )t[1] ).disable();
        }
        else
        {
          ( ( JButton )t[1] ).enable();
        }
      }
    }
    else
    {
      panButtons.setLayout( new GridLayout( 0 , 1 ) );
      for ( int i = 0 ; i < buttons1.length ; i++ )
      {
        t = ( Object[] )Hbuttons.get( buttons1[ i ] );
        t[1] = new JButton( (String)t[4] );
        ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
        ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
        ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
        if ( ( (String)( t[0] ) ).equals( "Button" ) )
        {
          ( ( JButton )t[1] ).addActionListener( new ButtonListener( (String)t[2] , "-1" , -1 , this ) );
        }
        else if ( ( (String)( t[0] ) ).equals( "Menubutton" ) )
        {
          ( ( JButton )t[1] ).addActionListener( mbl );
        }
        ( ( JButton )t[1] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        panButtons.add( ( JButton )t[1] );
        if ( ( (String)t[3] ).equals( "disabled" ) )
        {
          ( ( JButton )t[1] ).disable();
        }
        else
        {
          ( ( JButton )t[1] ).enable();
        }
      }
      panButtons2.setLayout( new GridLayout( 0 , 1 ) );
      for ( int i = 0 ; i < buttons2.length ; i++ )
      {
        t = ( Object[] )Hbuttons.get( buttons2[ i ] );
        t[1] = new JButton( (String)t[4] );
        ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
        ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
        ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
        if ( ( (String)( t[0] ) ).equals( "Button" ) )
        {
          ( ( JButton )t[1] ).addActionListener( new ButtonListener( (String)t[2] , "-1" , -1 , this ) );
        }
        else if ( ( (String)( t[0] ) ).equals( "Menubutton" ) )
        {
          ( ( JButton )t[1] ).addActionListener( mbl );
        }
        ( ( JButton )t[1] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
        panButtons2.add( ( JButton )t[1] );
        if ( ( (String)t[3] ).equals( "disabled" ) )
        {
          ( ( JButton )t[1] ).disable();
        }
        else
        {
          ( ( JButton )t[1] ).enable();
        }
      }
    }

    //---------------------------------
    if ( look == GDG3DTetrisCstes.Expanded ) panStages.setBounds( XPanStages , YPanStages , widthPanStages , heightPanStages );
    pan.setBounds( XPan , YPan , widthPan , heightPan );
    if ( look == GDG3DTetrisCstes.Expanded )
    {
      panButtons.setBounds( XPanButtons , YPanButtons , widthPanButtons , heightPanButtons );
    }
    else
    {
      panButtons.setBounds( XPanButtons , YPanButtons , widthPanButtons , heightPanButtons );
      panButtons2.setBounds( XPanButtons2 , YPanButtons2 , widthPanButtons2 , heightPanButtons2 );
    }
    panNextForme.setBounds( XPanNextForme , YPanNextForme , widthPanNextForme , heightPanNextForme );
    panInst1.setBounds( XPanInst1 , YPanInst1 , widthPanInst1 , heightPanInst1 );
    panInst2.setBounds( XPanInst2 , YPanInst2 , widthPanInst2 , heightPanInst2 );
    panInst3.setBounds( XPanInst3 , YPanInst3 , widthPanInst3 , heightPanInst3 );
    panInst4.setBounds( XPanInst4 , YPanInst4 , widthPanInst4 , heightPanInst4 );

    ( ( JButton ) ( ( ( Object[] ) Hbuttons.get( "pause" ) )[ 1 ] ) ).setEnabled( false );

    //---------------------------------
    panInst1.setLayout( new BorderLayout() );
    t = ( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) );
    t[1] = new JButton( "Rotation OY" );
    ( ( JButton )t[ 1 ] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
    ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
    ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
    ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
    panInst1.add( ( JButton )t[1] , BorderLayout.NORTH );
    ( ( JButton )t[1] ).addActionListener( mbl );

    panInst2.setLayout( new BorderLayout() );
    t = ( ( Object[] )Hbuttons.get( "buttonChangeRotOX" ) );
    t[1] = new JButton( "Rotation OX" );
    ( ( JButton )t[ 1 ] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
    ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
    ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
    ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
    panInst2.add( ( JButton )t[1] , BorderLayout.NORTH );
    ( ( JButton )t[1] ).addActionListener( mbl );

    panInst3.setLayout( new BorderLayout() );
    t = ( ( Object[] )Hbuttons.get( "buttonChangeRotOZ" ) );
    t[1] = new JButton( "Rotation OZ" );
    ( ( JButton )t[ 1 ] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
    ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
    ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
    ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
    panInst3.add( ( JButton )t[1] , BorderLayout.NORTH );
    ( ( JButton )t[1] ).addActionListener( mbl );

    panInst4.setLayout( new BorderLayout() );
    t = ( ( Object[] )Hbuttons.get( "buttonChangeDepOXOY" ) );
    t[1] = new JButton( "Deplacement" );
    ( ( JButton )t[ 1 ] ).setFont( new Font( "Courrier New" , Font.BOLD , 10 ) );
    ( ( JButton )t[ 1 ] ).setBackground( Color.orange );
    ( ( JButton )t[ 1 ] ).setBorder( new EtchedBorder( EtchedBorder.RAISED ) );
    ( ( JButton )t[ 1 ] ).setRequestFocusEnabled( false );
    panInst4.add( ( JButton )t[1] , BorderLayout.NORTH );
    ( ( JButton )t[1] ).addActionListener( mbl );

    //---------------------------------
    TitledBorder tb = new TitledBorder( " gdg 3D Tetris " );
    tb.setTitleColor( Color.red );
    tb.setTitleJustification( TitledBorder.RIGHT );
    cp.setBorder( tb );

    //---------------------------------
    java.awt.Image imIcon = new javax.swing.ImageIcon( ".\\Icon.jpg" ).getImage();
    setIconImage( imIcon );

    //---------------------------------
    setVisible( true );

    //---------------------------------
    if ( look == GDG3DTetrisCstes.Expanded ) gPanStages = panStages.getGraphics();
    g = pan.getGraphics();
    gPanNextForme = panNextForme.getGraphics();
    gPanInst1 = panInst1.getGraphics();
    gPanInst2 = panInst2.getGraphics();
    gPanInst3 = panInst3.getGraphics();
    gPanInst4 = panInst4.getGraphics();

    //---------------------------------
    File f = new File( ".\\T3DsceneTraining.txt" );
    if ( ! f.exists() )
    {
      System.out.println( "message> writing first configuration file.\n\n" );

      sceneTraining = new Volume( GDG3DTetrisCstes.TRAINING_SCENE , Color.green , true , true );

      sceneTraining.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , Color.green , null );

      FileOutputStream fo = null;
      try
      {
        fo = new FileOutputStream( f );
        ObjectOutputStream out = new ObjectOutputStream( fo );
        out.writeObject( sceneTraining );
      }
      catch ( Exception e )
      {
        System.out.println( e.toString() );
      }
      finally
      {
        try{ fo.close(); } catch(Exception e){}
      }

    }
    else
    {
      FileInputStream fi = null;
      try
      {
        fi = new FileInputStream( f );
        ObjectInputStream in = new ObjectInputStream( fi );
        sceneTraining = (Volume)in.readObject();
      }
      catch ( Exception e )
      {
        System.out.println( e.toString() );
      }
      finally
      {
        try{ fi.close(); } catch(Exception e){}
      }
    }

    sceneTraining.setCalculateForNewPosition( true );

    scaleXTraining = sizeX / ( ( GDG3DTetrisCstes.TRAINING_SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) + .17;
    scaleYTraining = sizeY / ( ( GDG3DTetrisCstes.TRAINING_SCENE[0].length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) + .17;

    offsetXTraining = (int)sizeX / 2;
    offsetYTraining = (int)sizeY / 2;

    obsXTraining = ( ( GDG3DTetrisCstes.TRAINING_SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) / 2 + GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION - 100;
    obsYTraining = ( ( GDG3DTetrisCstes.TRAINING_SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) / 2 + GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION - 100;

    formeTraining = new Volume( (GDG3DTetrisCstes.FORMES)[ 4 ] , (GDG3DTetrisCstes.COLORS_FORMES)[ rand.nextInt( GDG3DTetrisCstes.COLORS_FORMES.length ) ] , true , true );

    formeTraining.setCalculateForNewPosition( true );

    formeTraining.recentMiddle();

    Point scenePXminYminZmin = sceneTraining.getPXminYminZmin();

    Point formePXminYminZmin = formeTraining.getPXminYminZmin();

    formeTraining.translate( scenePXminYminZmin.getX() - formePXminYminZmin.getX() ,
                             scenePXminYminZmin.getY() - formePXminYminZmin.getY() ,
                             scenePXminYminZmin.getZ() - formePXminYminZmin.getZ() );

    formeTraining.translateZPlusOneUnit();
    formeTraining.translateZPlusOneUnit();

    //---------------------------------
    f = new File( ".\\T3DscenePlaying.txt" );
    if ( ! f.exists() )
    {
      System.out.println( "message> writing second configuration file.\n\n" );

      scenePlaying = new Volume( GDG3DTetrisCstes.SCENE , Color.green , true , true );

      scenePlaying.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , Color.green , null );

      FileOutputStream fo = null;
      try
      {
        fo = new FileOutputStream( f );
        ObjectOutputStream out = new ObjectOutputStream( fo );
        out.writeObject( scenePlaying );
      }
      catch ( Exception e )
      {
        System.out.println( e.toString() );
      }
      finally
      {
        try{ fo.close(); } catch(Exception e){}
      }

    }
    else
    {
      FileInputStream fi = null;
      try
      {
        fi = new FileInputStream( f );
        ObjectInputStream in = new ObjectInputStream( fi );
        scenePlaying = (Volume)in.readObject();
      }
      catch ( Exception e )
      {
        System.out.println( e.toString() );
      }
      finally
      {
        try{ fi.close(); } catch(Exception e){}
      }
    }

    scenePlaying.setCalculateForNewPosition( true );

    scaleXPlaying = sizeX / ( ( GDG3DTetrisCstes.SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) + .17;
    scaleYPlaying = sizeY / ( ( GDG3DTetrisCstes.SCENE[0].length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) + .17;

    offsetXPlaying = (int)sizeX / 2;
    offsetYPlaying = (int)sizeY / 2;

    obsXPlaying = ( ( GDG3DTetrisCstes.SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) / 2 + GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION - 100;
    obsYPlaying = ( ( GDG3DTetrisCstes.SCENE.length + 1 ) * GDG3DTetrisCstes.COTE_CARRE ) / 2 + GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION - 100;

    scene = scenePlaying;
    scaleX = scaleXPlaying;
    scaleY = scaleYPlaying;
    scaleYNextForme = scaleY * 0.95;
    obsX = obsXPlaying;
    obsY = obsYPlaying;
    offsetX = offsetXPlaying;
    offsetY = offsetYPlaying;

    //---------------------------------
    heap = new Volume();

    heap.setCalculateForNewPosition( true );

    heap.setNbStages( GDG3DTetrisCstes.SCENE );

    //---------------------------------
    drawPanInst();

    //---------------------------------
    addKeyListener( kl );
    this.requestFocus();

    //---------------------------------
    addWindowListener( new WindowAdapter() {
      public void windowClosing( WindowEvent e ) {
        Window w = e.getWindow();
        w.setVisible( false );
        System.exit( 0 );
      }
    } );

    //---------------------------------
    trainingMode = false;
    changingKeysMode = false;
    changingGameMode = false;
    pauseMode = false;
    newGameMode = true;
    endedGameMode = false;
    helpMode = false;
    observeHeapMode = false;

    //---------------------------------
    timerTop = new java.util.Timer();
    timerTop.schedule( flotTop , 0 , top );
    timerBigTop = new java.util.Timer();
    timerBigTop.schedule( flotBigTop , 0 , bigTop );

    //---------------------------------
    ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( false );

    //---------------------------------
    if ( ( opt_g != null ) && ( opt_g.length() != 0 ) )
    {
      loadGame();
    }
    else
    {
      heap = new Volume();

      heap.setCalculateForNewPosition( true );

      heap.setNbStages( GDG3DTetrisCstes.SCENE );

      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "startNewGameMode" ) );
      affMsgInPanNextForme( messInPanNextForme );

      help();
    }

    //---------------------------------
    drawStages( heap );

  }

  //---------------------------------------------------------------------------
  public void paint( Graphics gr )
  {
    super.paint( gr );

    if ( menuDevelopped == true ) return;

    eraseMsgPartOfPanNextForme();
    affMsgInPanNextForme( messInPanNextForme );

    if ( observeHeapMode == true )
    {
      erasePan();

      heapCloned.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );

      drawStages( heap );

      drawPanInst();

      eraseMsgPartOfPanNextForme();
      messInPanNextForme = (String)( Hmessages.get( "observeHeapMode" ) );
      affMsgInPanNextForme( messInPanNextForme );
    }
    else
    {
      erasePan();

      if ( helpMode == true )
      {
        erasePan();
        affMsgInPan( help );

        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "helpMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }
      else
      {
        drawSceneHeapForme();
        if ( trainingMode == false ) drawNextForme();
      }

      drawStages( heap );

      drawPanInst();

      if ( pauseMode == true )
      {
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "pauseMode" ) );
        affMsgInPanNextForme( messInPanNextForme );
      }

    }

  }

  //---------------------------------------------------------------------------
  public static void main(String[] args)
  {
    look = -1;

    //---------------------------------
    if ( args.length != 0 )
    {
      java.util.List l = java.util.Arrays.asList( args );
      ListIterator li = l.listIterator();
      int ind = 0;
      while ( li.hasNext() )
      {
        String s = (String)li.next();
        s.trim();
        if ( ( ind = s.lastIndexOf( "-" ) ) != 0 )
        {
          System.out.println( "Error : " + s );
          System.exit(1);
        }
        else
        {
          if ( s.length() == 1 )
          {
            s = (String)li.next();
            s.trim();
            ind = 0;
            if ( ( ind = s.lastIndexOf( "-" ) ) >= 0 )
            {
              System.out.println( "Error : " + s );
              System.exit(1);
            }
          }
          String t = null;
          StringTokenizer st = new StringTokenizer( s.substring( ind + 1 ) );
          while ( st.hasMoreTokens() )
          {
            t = st.nextToken();
            if ( t.equals( "h" ) )
            {
              for ( int i = 0 ; i < help.length ; i++ )
              {
                System.out.println( help[ i ] );
              }
              System.exit( 0 );
            } else if ( t.equals( "k" ) )
            {
              opt_k = (String)li.next();
            } else if ( t.equals( "g" ) )
            {
              opt_g = (String)li.next();
            } else if ( t.equals( "t" ) )
            {
              opt_t = Float.parseFloat( (String)li.next() );
            } else if ( t.equals( "e" ) )
            {
              look = GDG3DTetrisCstes.Expanded;
            } else if ( t.equals( "c" ) )
            {
              look = GDG3DTetrisCstes.Compact;
            }
          }
        }
      }
    }

    //---------------------------------
    double Horzres = Toolkit.getDefaultToolkit().getScreenSize().getWidth();
    double Vertres = Toolkit.getDefaultToolkit().getScreenSize().getHeight();

    if ( ( Horzres < 1400 ) || ( Vertres < 1050 ) )
    {
      look = Compact;
    }
    else if ( look == -1 )
    {
      int offset = 20;

      choicePan = new JFrame();

      choicePan.setResizable( false );

      choicePan.setTitle( gameTitle );

      javax.swing.ImageIcon imExpanded = null;
      javax.swing.ImageIcon imCompact = null;

      int heightImCompact = 0;
      int widthImCompact = 0;

      int heightImExpanded = 0;
      int widthImExpanded = 0;

      boolean noJPG;

      File f = new File( ".\\Expanded.jpg" );
      if ( f.exists() )
      {
        imExpanded = new javax.swing.ImageIcon( ".\\Expanded.jpg" );
        heightImExpanded = imExpanded.getIconHeight();
        widthImExpanded = imExpanded.getIconWidth();
        noJPG = false;
      } else noJPG = true;

      f = new File( ".\\Compact.jpg" );
      if ( ( noJPG == false ) && ( f.exists() ) )
      {
        imCompact = new javax.swing.ImageIcon( ".\\Compact.jpg" );
        heightImCompact = imCompact.getIconHeight();
        widthImCompact = imCompact.getIconWidth();
        noJPG = false;
      } else noJPG = true;

      java.awt.Image imIcon = new javax.swing.ImageIcon( ".\\Icon.jpg" ).getImage();
      choicePan.setIconImage( imIcon );

      String sChooseAlook = "Choose a look";
      String sExpanded = "\" Expanded \"";
      String sCompact = "\" Compact \"";

      JButton jbCompact = new JButton();
      if ( noJPG == false )
      {
        jbCompact.setIcon( imCompact );
        jbCompact.setBackground( Color.black );
      }
      else
      {
        jbCompact.setText( sCompact );
        heightImCompact = 20;
        widthImCompact = 8 * sCompact.length();
        jbCompact.setForeground( Color.yellow );
        jbCompact.setBackground( Color.gray );
      }
      jbCompact.addActionListener( new ActionListener() {
        public void actionPerformed( ActionEvent e )
        {
          look = GDG3DTetrisCstes.Compact;
          choicePan.setVisible( false );
          choicePan = null;
          game = new GDG3DTetris( GDG3DTetris.opt_t , GDG3DTetris.opt_k , GDG3DTetris.opt_g );
        }
      } );

      JButton jbExpanded = new JButton();
      if ( noJPG == false )
      {
        jbExpanded.setIcon( imExpanded );
        jbExpanded.setBackground( Color.black );
      }
      else
      {
        jbExpanded.setText( sExpanded );
        heightImExpanded = 20;
        widthImExpanded = 8 * sExpanded.length();
        jbExpanded.setForeground( Color.yellow );
        jbExpanded.setBackground( Color.gray );
      }
      jbExpanded.addActionListener( new ActionListener() {
        public void actionPerformed( ActionEvent e )
        {
          look = GDG3DTetrisCstes.Expanded;
          choicePan.setVisible( false );
          choicePan = null;
          game = new GDG3DTetris( GDG3DTetris.opt_t , GDG3DTetris.opt_k , GDG3DTetris.opt_g );
        }
      } );

      jbExpanded.setBounds( widthImCompact + offset * 2 , offset * 3 , widthImExpanded , heightImExpanded );
      jbExpanded.setBorder( null );
      jbExpanded.setRequestFocusEnabled( false );

      jbCompact.setBounds( offset , offset * 3 , widthImCompact , heightImCompact );
      jbCompact.setBorder( null );
      jbCompact.setRequestFocusEnabled( false );

      jbCompact.setVisible( true );
      jbExpanded.setVisible( true );

      Container cp = choicePan.getContentPane();
      cp.setLayout( null );
      cp.add( jbExpanded );
      cp.add( jbCompact );

      choicePan.addKeyListener( new KeyListener() {
        public void keyPressed( KeyEvent e ){ System.exit( 0 ); }
        public void keyReleased( KeyEvent e ){}
        public void keyTyped( KeyEvent e ){}
      } );

      choicePan.addWindowListener( new WindowAdapter() {
        public void windowClosing( WindowEvent e ) {
          Window w = e.getWindow();
          w.setVisible( false );
          System.exit( 0 );
        }
      } );

      choicePan.getContentPane().setBackground( Color.black );

      int w = widthImCompact + widthImExpanded + offset * 3;
      int h = heightImExpanded + offset * 5;
      choicePan.setBounds( (int)( Horzres / 2 ) - w / 2 , (int)( Vertres / 2 ) - h / 2 , w , h );
      choicePan.setVisible( true );

      Graphics gChoicePan = cp.getGraphics();
      gChoicePan.setColor( Color.green );
      gChoicePan.setFont( new Font( "Sans Serif" , Font.BOLD , 13 ) );
      gChoicePan.drawString( sChooseAlook , choicePan.getWidth() / 2 - ( sChooseAlook.length() * 8 ) / 2 , 20 );
      if ( noJPG == false )
      {
        gChoicePan.drawString( sExpanded , offset * 2 + widthImCompact + widthImExpanded / 2 - ( sExpanded.length() * 8 ) / 2 , 45 );
        gChoicePan.drawString( sCompact , offset + widthImCompact / 2 - ( sCompact.length() * 8 ) / 2 , 45 );
      }

    }
    //else
    //{
      game = new GDG3DTetris( GDG3DTetris.opt_t , GDG3DTetris.opt_k , GDG3DTetris.opt_g );
    //}

  }

  //---------------------------------------------------------------------------
  private void erasePan()
  {
    Insets i = pan.getInsets();
    g.setColor( Color.black );
    g.fillRect( 0 , 0 , (int)pan.getWidth() , (int)pan.getHeight() );
  }

  //---------------------------------------------------------------------------
  private void erasePanStages()
  {
    if ( look == GDG3DTetrisCstes.Compact ) return;
    Insets i = panStages.getInsets();
    gPanStages.setColor( Color.cyan );
    gPanStages.fillRect( i.right , i.top , (int)panStages.getWidth() - i.left * 2 , (int)panStages.getHeight() - i.bottom * 2 );
  }

  //---------------------------------------------------------------------------
  private void erasePanNextForme()
  {
    Insets i = panNextForme.getInsets();
    gPanNextForme.setColor( Color.black );
    gPanNextForme.fillRect( i.left , i.top , (int)panNextForme.getWidth() - i.right * 2 , (int)panNextForme.getHeight() - i.bottom * 2 );
  }

  //---------------------------------------------------------------------------
  private void erasePanInst()
  {
    int heightButtonChangeRotOY = ( ( JButton )( ( Object[] )Hbuttons.get( "buttonChangeRotOY" ) )[ 1 ] ).getHeight();

    gPanInst1.setColor( Color.green );
    Insets i = panInst1.getInsets();
    gPanInst1.fillRect( i.left , heightButtonChangeRotOY , (int)panInst1.getWidth() - i.right * 2 , (int)panInst1.getWidth() - heightButtonChangeRotOY - i.bottom * 2 );

    gPanInst2.setColor( Color.green );
    i = panInst2.getInsets();
    gPanInst2.fillRect( i.left , heightButtonChangeRotOY , (int)panInst2.getWidth() - i.right * 2 , (int)panInst2.getWidth() - heightButtonChangeRotOY - i.bottom * 2 );

    gPanInst3.setColor( Color.green );
    i = panInst3.getInsets();
    gPanInst3.fillRect( i.left , heightButtonChangeRotOY , (int)panInst3.getWidth() - i.right * 2 , (int)panInst3.getWidth() - heightButtonChangeRotOY - i.bottom * 2 );

    gPanInst4.setColor( Color.green );
    i = panInst4.getInsets();
    gPanInst4.fillRect( i.left , heightButtonChangeRotOY , (int)panInst4.getWidth() - i.right * 2 , (int)panInst4.getWidth() - heightButtonChangeRotOY - i.bottom * 2 );
  }

  //---------------------------------------------------------------------------
  private void eraseMsgPartOfPanNextForme()
  {
    Insets i = panNextForme.getInsets();
    gPanNextForme.setColor( Color.black );
    gPanNextForme.fillRect( i.left , i.right , (int)panNextForme.getWidth() - i.right * 2 , (int)( panNextForme.getHeight() / 4 ) );
  }

  //---------------------------------------------------------------------------
  private void affMsgInPanNextForme( String s )
  {
      gPanNextForme.setColor( Color.green );

      int i = 85 , y = 15;
      StringBuffer bS1 = new StringBuffer( s );
      StringBuffer bS2 = new StringBuffer( s );
      while ( bS2.length() > i )
      {
        while ( bS2.charAt( i ) !=  ' ' )
        {
          i--;
        }
        bS1.replace( 0 , bS1.length() , bS2.substring( 0 , i + 1 ) );
        gPanNextForme.drawString( bS1.toString() , 10 , y );
        bS2.delete( 0 , i + 1 );
        bS1.replace( 0 , bS1.length() , bS2.toString() );
        y += 15;
      }
      gPanNextForme.drawString( bS1.toString() , 10 , y );
  }

  //---------------------------------------------------------------------------
  private void affMsgInPan( String[] s )
  {
      g.setFont( new Font( "Terminal" , Font.PLAIN , 10 ) );
      g.setColor( Color.green );
      for ( int i = 0 ; i < s.length ; i++ )
      {
        g.drawString( s[ i ] , 10 , 20 * i + 20 );
      }
  }

  //---------------------------------------------------------------------------
  private void drawScene()
  {
    if ( scene != null ) scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
  }

  //---------------------------------------------------------------------------
  private void drawSceneHeapForme()
  {
    if ( scene != null ) scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
    if ( ( heap != null ) && ( trainingMode == false ) ) heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
    if ( forme != null ) forme.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , colorForme , heap );
  }

  //---------------------------------------------------------------------------
  private void drawForme()
  {
    if ( forme != null ) forme.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , colorForme , heap );
  }

  //---------------------------------------------------------------------------
  private void drawNextForme()
  {
    if ( look == Expanded )
    {
      if ( nextForme != null ) nextForme.draw( gPanNextForme , -dist , obsX / 1.9 , obsY / 1.9 , obsZ / 2 , scaleX , scaleYNextForme , 0 , 0 , null , null );
    }
    else
    {
      if ( nextForme != null ) nextForme.draw( gPanNextForme , -dist , obsX / 10 , obsY / 1.9 , obsZ / 2 , scaleX / 2 , scaleYNextForme / 2 , 0 , 0 , null , null );
    }
  }

  //---------------------------------------------------------------------------
  private void drawHeap()
  {
    if ( heap != null ) heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
  }

  //---------------------------------------------------------------------------
  private void drawHeapCloned()
  {
    if ( heapCloned != null ) heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
  }

  //---------------------------------------------------------------------------
  private void down( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.translateYPlusOneUnit();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.translateYMinusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantDown" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.translateYMinusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantDown" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void up( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.translateYMinusOneUnit();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.translateYPlusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantUp" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.translateYPlusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantUp" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void left( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.translateXMinusOneUnit();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.translateXPlusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantLeft" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.translateXPlusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantLeft" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void right( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.translateXPlusOneUnit();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.translateXMinusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRight" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.translateXMinusOneUnit();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRight" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotatePlus90Deg_OX( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotatePlus90Deg_OX();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotateMoins90Deg_OX();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotateMoins90Deg_OX();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotateMoins90Deg_OX( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotateMoins90Deg_OX();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotatePlus90Deg_OX();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotatePlus90Deg_OX();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotatePlus90Deg_OY( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotatePlus90Deg_OY();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotateMoins90Deg_OY();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotateMoins90Deg_OY();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotateMoins90Deg_OY( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotateMoins90Deg_OY();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotatePlus90Deg_OY();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotatePlus90Deg_OY();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotatePlus90Deg_OZ( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotatePlus90Deg_OZ();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotateMoins90Deg_OZ();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotateMoins90Deg_OZ();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void rotateMoins90Deg_OZ( boolean draw )
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();
      if ( draw ) drawForme();
      forme.rotateMoins90Deg_OZ();

      if ( scene.isVolumeAllInside( forme ) == false )
      {
        forme.rotatePlus90Deg_OZ();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }

      if ( ( trainingMode == false ) && ( heap != null ) && ( heap.intersect( forme ) == true ) )
      {
        forme.rotatePlus90Deg_OZ();
        if ( draw ) drawForme();
        eraseMsgPartOfPanNextForme();
        messInPanNextForme = (String)( Hmessages.get( "cantRotate" ) );
        affMsgInPanNextForme( messInPanNextForme );
        formeOnMove = false;
        return;
      }
      if ( draw ) drawForme();
      formeOnMove = false;
    }
  }

  //---------------------------------------------------------------------------
  private void fall()
  {
    if ( ( formeOnMove == true ) || ( forme == null ) || ( pauseMode == true ) || ( helpMode == true ) ||
    ( changingKeysMode == true ) || ( changingGameMode == true ) )
    {
      return;
    }

    formeOnMove = true;

    synchronized( forme )
    {
      eraseMsgPartOfPanNextForme();

      drawForme();

      Object[] t = null;
      while ( true )
      {
        forme.translateZPlusOneUnit();

        if ( heap.intersect( forme ) == true )
        {
          forme.translateZMinusOneUnit();
          if ( heap.insertVolume( forme ) == false )
          {
            newGameMode = false;
            endedGameMode = true;
            messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
            affMsgInPanNextForme( messInPanNextForme );
          }
          ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
          heap.setCalculateForNewPosition( true );
          heap.setFill();
          drawStages( heap );
          //erasePanNextForme();
          erasePan();
          scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          forme = null;
          break;
        }

        if ( scene.isVolumeAllInside( forme ) == false )
        {
          forme.translateZMinusOneUnit();
          if ( heap.insertVolume( forme ) == false )
          {
            newGameMode = false;
            endedGameMode = true;
            messInPanNextForme = (String)( Hmessages.get( "newGameMode" ) );
            affMsgInPanNextForme( messInPanNextForme );
          }
          ( ( JButton )( ( Object[] )Hbuttons.get( "observeHeap" ) )[ 1 ] ).setEnabled( true );
          heap.setCalculateForNewPosition( true );
          heap.setFill();
          drawStages( heap );
          //erasePanNextForme();
          erasePan();
          scene.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          heap.draw( g , -dist , obsX , obsY , obsZ , scaleX , scaleY , offsetX , offsetY , null , null );
          forme = null;
          break;
        }
      }
    }

    formeOnMove = false;
  }

}


// ===========================================================================
// interface =================================================================
// ===========================================================================
interface GDG3DTetrisCstes
{
  public final int Expanded = 1;
  public final int Compact = 2;

  public final int Y_MAX_SCENE = 10;
  public final int X_MAX_SCENE = 10;
  public final int Z_MAX_SCENE = 12;

  public final int Y_MAX_FORME = 5;
  public final int X_MAX_FORME = 5;
  public final int Z_MAX_FORME = 5;

  public final int COTE_CARRE = 200;

  public final int OFFSET = 0;

  public final int OFFSET_FOR_GOOD_PRECISION = 1000;

  public final short[][][] FORME_1 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,7,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][] FORME_2 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,7,7,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][] FORME_3 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,7,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][] FORME_4 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][] FORME_5 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,7,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{0,7,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][] FORME_6 =
  {// y = 0        y = 1        y = 2        y = 3        y = 4
//z 0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4    0 1 2 3 4
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 0
  {{7,7,0,0,0}, {7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 1
  {{7,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 2
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}, // x = 3
  {{0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}, {0,0,0,0,0}}  // x = 4
  };

  public final short[][][][] FORMES = { FORME_1 , FORME_2 , FORME_3 , FORME_4 , FORME_5 , FORME_6 };

  public final Color[] COLORS_FORMES = {
  new Color( 0x99 , 0x99 , 0x99 ).brighter().brighter() ,
  new Color( 0x83 , 0x6f , 0xff ).brighter().brighter() ,
  new Color( 0x7a , 0x67 , 0xee ).brighter().brighter() ,
  new Color( 0x69 , 0x59 , 0xcd ).brighter().brighter() ,
  new Color( 0x47 , 0x3c , 0x8b ).brighter().brighter() ,
  new Color( 0x48 , 0x76 , 0xff ).brighter().brighter() ,
  new Color( 0x43 , 0x6e , 0xee ).brighter().brighter() ,
  new Color( 0x3a , 0x5f , 0xcd ).brighter().brighter() ,
  new Color( 0x27 , 0x40 , 0x8b ).brighter().brighter() ,
  new Color( 0x00 , 0x00 , 0xff ).brighter().brighter() ,
  new Color( 0x00 , 0x00 , 0xee ).brighter().brighter() ,
  new Color( 0x00 , 0x00 , 0xcd ).brighter().brighter() ,
  new Color( 0x00 , 0x00 , 0x8b ).brighter().brighter() ,
  new Color( 0x1e , 0x90 , 0xff ).brighter().brighter() ,
  new Color( 0x1c , 0x86 , 0xee ).brighter().brighter() ,
  new Color( 0x18 , 0x74 , 0xcd ).brighter().brighter() ,
  new Color( 0x10 , 0x4e , 0x8b ).brighter().brighter() ,
  new Color( 0x63 , 0xb8 , 0xff ).brighter().brighter() ,
  new Color( 0x5c , 0xac , 0xee ).brighter().brighter() ,
  new Color( 0x4f , 0x94 , 0xcd ).brighter().brighter() ,
  new Color( 0x36 , 0x64 , 0x8b ).brighter().brighter() ,
  new Color( 0x00 , 0xbf , 0xff ).brighter().brighter() ,
  new Color( 0x00 , 0xb2 , 0xee ).brighter().brighter() ,
  new Color( 0x00 , 0x9a , 0xcd ).brighter().brighter() ,
  new Color( 0x00 , 0x68 , 0x8b ).brighter().brighter() ,
  new Color( 0x00 , 0xf5 , 0xff ).brighter().brighter() ,
  new Color( 0x00 , 0xe5 , 0xee ).brighter().brighter() ,
  new Color( 0x00 , 0xc5 , 0xcd ).brighter().brighter() ,
  new Color( 0x00 , 0x86 , 0x8b ).brighter().brighter() ,
  new Color( 0x00 , 0xff , 0xff ).brighter().brighter() ,
  new Color( 0x00 , 0xee , 0xee ).brighter().brighter() ,
  new Color( 0x00 , 0xcd , 0xcd ).brighter().brighter() ,
  new Color( 0x00 , 0x8b , 0x8b ).brighter().brighter() ,
  new Color( 0x54 , 0xff , 0x9f ).brighter().brighter() ,
  new Color( 0x4e , 0xee , 0x94 ).brighter().brighter() ,
  new Color( 0x43 , 0xcd , 0x80 ).brighter().brighter() ,
  new Color( 0x2e , 0x8b , 0x57 ).brighter().brighter() ,
  new Color( 0x00 , 0xff , 0x7f ).brighter().brighter() ,
  new Color( 0x00 , 0xee , 0x76 ).brighter().brighter() ,
  new Color( 0x00 , 0xcd , 0x66 ).brighter().brighter() ,
  new Color( 0x00 , 0x8b , 0x45 ).brighter().brighter() ,
  new Color( 0x00 , 0xff , 0x00 ).brighter().brighter() ,
  new Color( 0x00 , 0xee , 0x00 ).brighter().brighter() ,
  new Color( 0x00 , 0xcd , 0x00 ).brighter().brighter() ,
  new Color( 0x00 , 0x8b , 0x00 ).brighter().brighter() ,
  new Color( 0x7f , 0xff , 0x00 ).brighter().brighter() ,
  new Color( 0x76 , 0xee , 0x00 ).brighter().brighter() ,
  new Color( 0x66 , 0xcd , 0x00 ).brighter().brighter() ,
  new Color( 0x45 , 0x8b , 0x00 ).brighter().brighter() ,
  new Color( 0xc0 , 0xff , 0x3e ).brighter().brighter() ,
  new Color( 0xb3 , 0xee , 0x3a ).brighter().brighter() ,
  new Color( 0x9a , 0xcd , 0x32 ).brighter().brighter() ,
  new Color( 0x69 , 0x8b , 0x22 ).brighter().brighter() ,
  new Color( 0xca , 0xff , 0x70 ).brighter().brighter() ,
  new Color( 0xbc , 0xee , 0x68 ).brighter().brighter() ,
  new Color( 0xa2 , 0xcd , 0x5a ).brighter().brighter() ,
  new Color( 0x6e , 0x8b , 0x3d ).brighter().brighter() ,
  new Color( 0xff , 0xf6 , 0x8f ).brighter().brighter() ,
  new Color( 0xee , 0xe6 , 0x85 ).brighter().brighter() ,
  new Color( 0xcd , 0xc6 , 0x73 ).brighter().brighter() ,
  new Color( 0x8b , 0x86 , 0x4e ).brighter().brighter() ,
  new Color( 0xff , 0xff , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0xee , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0xcd , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x8b , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0xd7 , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0xc9 , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0xad , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x75 , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0xc1 , 0x25 ).brighter().brighter() ,
  new Color( 0xee , 0xb4 , 0x22 ).brighter().brighter() ,
  new Color( 0xcd , 0x9b , 0x1d ).brighter().brighter() ,
  new Color( 0x8b , 0x69 , 0x14 ).brighter().brighter() ,
  new Color( 0xff , 0xb9 , 0x0f ).brighter().brighter() ,
  new Color( 0xee , 0xad , 0x0e ).brighter().brighter() ,
  new Color( 0xcd , 0x95 , 0x0c ).brighter().brighter() ,
  new Color( 0x8b , 0x65 , 0x08 ).brighter().brighter() ,
  new Color( 0xff , 0xc1 , 0xc1 ).brighter().brighter() ,
  new Color( 0xee , 0xb4 , 0xb4 ).brighter().brighter() ,
  new Color( 0xcd , 0x9b , 0x9b ).brighter().brighter() ,
  new Color( 0x8b , 0x69 , 0x69 ).brighter().brighter() ,
  new Color( 0xff , 0x6a , 0x6a ).brighter().brighter() ,
  new Color( 0xee , 0x63 , 0x63 ).brighter().brighter() ,
  new Color( 0xcd , 0x55 , 0x55 ).brighter().brighter() ,
  new Color( 0x8b , 0x3a , 0x3a ).brighter().brighter() ,
  new Color( 0xff , 0x82 , 0x47 ).brighter().brighter() ,
  new Color( 0xee , 0x79 , 0x42 ).brighter().brighter() ,
  new Color( 0xcd , 0x68 , 0x39 ).brighter().brighter() ,
  new Color( 0x8b , 0x47 , 0x26 ).brighter().brighter() ,
  new Color( 0xcd , 0xaa , 0x7d ).brighter().brighter() ,
  new Color( 0x8b , 0x73 , 0x55 ).brighter().brighter() ,
  new Color( 0xff , 0xa5 , 0x4f ).brighter().brighter() ,
  new Color( 0xee , 0x9a , 0x49 ).brighter().brighter() ,
  new Color( 0xcd , 0x85 , 0x3f ).brighter().brighter() ,
  new Color( 0x8b , 0x5a , 0x2b ).brighter().brighter() ,
  new Color( 0xff , 0x7f , 0x24 ).brighter().brighter() ,
  new Color( 0xee , 0x76 , 0x21 ).brighter().brighter() ,
  new Color( 0xcd , 0x66 , 0x1d ).brighter().brighter() ,
  new Color( 0x8b , 0x45 , 0x13 ).brighter().brighter() ,
  new Color( 0xff , 0x30 , 0x30 ).brighter().brighter() ,
  new Color( 0xee , 0x2c , 0x2c ).brighter().brighter() ,
  new Color( 0xcd , 0x26 , 0x26 ).brighter().brighter() ,
  new Color( 0x8b , 0x1a , 0x1a ).brighter().brighter() ,
  new Color( 0xff , 0x40 , 0x40 ).brighter().brighter() ,
  new Color( 0xee , 0x3b , 0x3b ).brighter().brighter() ,
  new Color( 0xcd , 0x33 , 0x33 ).brighter().brighter() ,
  new Color( 0x8b , 0x23 , 0x23 ).brighter().brighter() ,
  new Color( 0xff , 0x8c , 0x69 ).brighter().brighter() ,
  new Color( 0xee , 0x82 , 0x62 ).brighter().brighter() ,
  new Color( 0xcd , 0x70 , 0x54 ).brighter().brighter() ,
  new Color( 0x8b , 0x4c , 0x39 ).brighter().brighter() ,
  new Color( 0xff , 0xa5 , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0x9a , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0x85 , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x5a , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0x7f , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0x76 , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0x66 , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x45 , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0x72 , 0x56 ).brighter().brighter() ,
  new Color( 0xee , 0x6a , 0x50 ).brighter().brighter() ,
  new Color( 0xcd , 0x5b , 0x45 ).brighter().brighter() ,
  new Color( 0x8b , 0x3e , 0x2f ).brighter().brighter() ,
  new Color( 0xff , 0x63 , 0x47 ).brighter().brighter() ,
  new Color( 0xee , 0x5c , 0x42 ).brighter().brighter() ,
  new Color( 0xcd , 0x4f , 0x39 ).brighter().brighter() ,
  new Color( 0x8b , 0x36 , 0x26 ).brighter().brighter() ,
  new Color( 0xff , 0x45 , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0x40 , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0x37 , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x25 , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0x00 , 0x00 ).brighter().brighter() ,
  new Color( 0xee , 0x00 , 0x00 ).brighter().brighter() ,
  new Color( 0xcd , 0x00 , 0x00 ).brighter().brighter() ,
  new Color( 0x8b , 0x00 , 0x00 ).brighter().brighter() ,
  new Color( 0xff , 0x14 , 0x93 ).brighter().brighter() ,
  new Color( 0xee , 0x12 , 0x89 ).brighter().brighter() ,
  new Color( 0xcd , 0x10 , 0x76 ).brighter().brighter() ,
  new Color( 0x8b , 0x0a , 0x50 ).brighter().brighter() ,
  new Color( 0xff , 0x6e , 0xb4 ).brighter().brighter() ,
  new Color( 0xee , 0x6a , 0xa7 ).brighter().brighter() ,
  new Color( 0xcd , 0x60 , 0x90 ).brighter().brighter() ,
  new Color( 0x8b , 0x3a , 0x62 ).brighter().brighter() ,
  new Color( 0xff , 0x82 , 0xab ).brighter().brighter() ,
  new Color( 0xee , 0x79 , 0x9f ).brighter().brighter() ,
  new Color( 0xcd , 0x68 , 0x89 ).brighter().brighter() ,
  new Color( 0x8b , 0x47 , 0x5d ).brighter().brighter() ,
  new Color( 0xff , 0x34 , 0xb3 ).brighter().brighter() ,
  new Color( 0xee , 0x30 , 0xa7 ).brighter().brighter() ,
  new Color( 0xcd , 0x29 , 0x90 ).brighter().brighter() ,
  new Color( 0x8b , 0x1c , 0x62 ).brighter().brighter() ,
  new Color( 0xff , 0x3e , 0x96 ).brighter().brighter() ,
  new Color( 0xee , 0x3a , 0x8c ).brighter().brighter() ,
  new Color( 0xcd , 0x32 , 0x78 ).brighter().brighter() ,
  new Color( 0x8b , 0x22 , 0x52 ).brighter().brighter() ,
  new Color( 0xff , 0x00 , 0xff ).brighter().brighter() ,
  new Color( 0xee , 0x00 , 0xee ).brighter().brighter() ,
  new Color( 0xcd , 0x00 , 0xcd ).brighter().brighter() ,
  new Color( 0x8b , 0x00 , 0x8b ).brighter().brighter() ,
  new Color( 0xbf , 0x3e , 0xff ).brighter().brighter() ,
  new Color( 0xb2 , 0x3a , 0xee ).brighter().brighter() ,
  new Color( 0x9a , 0x32 , 0xcd ).brighter().brighter() ,
  new Color( 0x68 , 0x22 , 0x8b ).brighter().brighter() ,
  new Color( 0x9b , 0x30 , 0xff ).brighter().brighter() ,
  new Color( 0x91 , 0x2c , 0xee ).brighter().brighter() ,
  new Color( 0x7d , 0x26 , 0xcd ).brighter().brighter() ,
  new Color( 0x55 , 0x1a , 0x8b ).brighter().brighter() ,
  new Color( 0xab , 0x82 , 0xff ).brighter().brighter() ,
  new Color( 0x9f , 0x79 , 0xee ).brighter().brighter() ,
  new Color( 0x89 , 0x68 , 0xcd ).brighter().brighter() ,
  new Color( 0x5d , 0x47 , 0x8b ).brighter().brighter()
  };

  public final short[][][] SCENE =
  {
  { { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 30 , 32 } } ,
  };

  public final short[][][] TRAINING_SCENE =
  {
  { { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } } ,
  { { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } , { 30 , 30 , 30 , 30 , 30 , 32 } }
  };


  public final short CODE_CARRE_ParallelToYZPlan_XNull = 2;
  public final Surface CARRE_ParallelToYZPlan_XNull =
  new Surface(
              new Point[]{
                          new Point(0,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CARRE_ParallelToYZPlan_XNotNull = 4;
  public final Surface CARRE_ParallelToYZPlan_XNotNull =
  new Surface(
              new Point[]{
                          new Point(COTE_CARRE,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CARRE_ParallelToXZPlan_YNull = 8;
  public final Surface CARRE_ParallelToXZPlan_YNull =
  new Surface(
              new Point[]{
                          new Point(0,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CARRE_ParallelToXZPlan_YNotNull = 16;
  public final Surface CARRE_ParallelToXZPlan_YNotNull =
  new Surface(
              new Point[]{
                          new Point(0,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CARRE_ParallelToXYPlan_ZNull = 32;
  public final Surface CARRE_ParallelToXYPlan_ZNull =
  new Surface(
              new Point[]{
                          new Point(0,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,0,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,COTE_CARRE,0).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CARRE_ParallelToXYPlan_ZNotNull = 64;
  public final Surface CARRE_ParallelToXYPlan_ZNotNull =
  new Surface(
              new Point[]{
                          new Point(0,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(0,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,COTE_CARRE,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION ),
                          new Point(COTE_CARRE,0,COTE_CARRE).translate( OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION , OFFSET_FOR_GOOD_PRECISION )
                          }
              , null);

  public final short CODE_CUBE_EN_0_0_0 = 7;
  public final Surface[] CUBE_EN_0_0_0 = {CARRE_ParallelToYZPlan_XNull, CARRE_ParallelToYZPlan_XNotNull,
                                          CARRE_ParallelToXZPlan_YNull, CARRE_ParallelToXZPlan_YNotNull,
                                          CARRE_ParallelToXYPlan_ZNull, CARRE_ParallelToXYPlan_ZNotNull};

  }


// =============================================================================
// class =======================================================================
// =============================================================================
class Point implements Comparable, GDG3DTetrisCstes , java.io.Serializable {

  private double x, y, z;

  //-----------------------------------------------------------------------------
  public Point()
  {
  }

  //-----------------------------------------------------------------------------
  public Point(double x, double y, double z)
  {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  //-----------------------------------------------------------------------------
  public Point(Point p)
  {
    this( p.getX() , p.getY() , p.getZ() );
  }

  //-----------------------------------------------------------------------------
  public double getX()
  {
    return x;
  }

  //-----------------------------------------------------------------------------
  public double getY()
  {
    return y;
  }

  //-----------------------------------------------------------------------------
  public double getZ()
  {
    return z;
  }

  //-----------------------------------------------------------------------------
  public void setX( double x )
  {
    this.x = x;
  }

  //-----------------------------------------------------------------------------
  public void setY( double y )
  {
    this.y = y;
  }

  //-----------------------------------------------------------------------------
  public void setZ( double z )
  {
    this.z = z;
  }

  //-----------------------------------------------------------------------------
  public void setXYZ( double x , double y , double z )
  {
    this.x = x;
    this.y = y;
    this.z = z;
  }

  //-----------------------------------------------------------------------------
  public void setXYZ( Point p )
  {
    this.x = p.x;
    this.y = p.y;
    this.z = p.z;
  }

  //-----------------------------------------------------------------------------
  public int compareTo( Object o )
  {
    Point p = (Point)o;
    if ( ( x == p.x ) && ( y == p.y ) && ( z == p.z ) ) return 0;
    return 1;
  }

  //-----------------------------------------------------------------------------
  public boolean equals( Object o )
  {
    if ( compareTo( (Point)o ) == 0 )
    {
      return true;
    } else return false;
  }

  //-----------------------------------------------------------------------------
  public Point translate( double x , double y , double z )
  {
    this.x += x;
    this.y += y;
    this.z += z;
    return this;
  }

  //-----------------------------------------------------------------------------
  public Point rotate( double[][] rotate , double xC , double yC , double zC )
  {
    double xx = 0 , yy = 0 , zz = 0 , xxx = x - xC , yyy = y - yC , zzz = z - zC;

    xx = xxx * rotate[0][0] + yyy * rotate[0][1] + zzz * rotate[0][2] + xC;
    yy = xxx * rotate[1][0] + yyy * rotate[1][1] + zzz * rotate[1][2] + yC;
    zz = xxx * rotate[2][0] + yyy * rotate[2][1] + zzz * rotate[2][2] + zC;

    x = xx; y = yy; z = zz;

    return this;
  }

  //-----------------------------------------------------------------------------
  public void draw( Graphics g , double obsZ , double x , double y , double z , double scaleX , double scaleY , int offsetX , int offsetY , Color xColor )
  {
    int xp = 0, yp = 0;

    if ( xColor != null ) g.setXORMode( xColor );

    if ( ( this.z - z ) <= 0 )
    {
      return;
    }
    int denom = (int)( this.z - z + Math.abs( obsZ ) );
    if ( denom == 0 )
    {
      return;
    }
    xp = (int)( (int)( ( this.x - x ) * Math.abs( obsZ ) ) / denom );
    yp = (int)( (int)( ( this.y - y ) * Math.abs( obsZ ) ) / denom );
    xp = (int)( xp * scaleX ) + offsetX;
    yp = (int)( yp * scaleY ) + offsetY;

    g.drawLine( xp , yp , xp+1 , yp+1 );

    if ( xColor != null ) g.setPaintMode();
  }

}


// =============================================================================
// class =======================================================================
// =============================================================================
class Segment implements Comparable, GDG3DTetrisCstes , java.io.Serializable {

  Point p1, p2;
  int xp1, yp1, xp2, yp2;
  Color color;

  //-----------------------------------------------------------------------------
  public Segment()
  {
  }

  //-----------------------------------------------------------------------------
  public Segment( Point p , Point pp , Color c )
  {
    p1 = p;
    p2 = pp;
    color = c;
  }

  //-----------------------------------------------------------------------------
  public int[] calcProjection( double obsZ , double x , double y , double z , double scaleX , double scaleY , int offsetX , int offsetY )
  {
    if ( ( ( p1.getZ() - z ) <= 0 ) || ( ( p2.getZ() - z ) <= 0 ) )
    {
      return null;
    }
    int denom1 = (int)( p1.getZ() - z + Math.abs( obsZ ) );
    if ( denom1 == 0 )
    {
      return null;
    }
    int denom2 = (int)( p2.getZ() - z + Math.abs( obsZ ) );
    if ( denom2 == 0 )
    {
      return null;
    }
    xp1 = (int)( (int)( ( p1.getX() - x ) * Math.abs( obsZ ) ) / denom1 );
    yp1 = (int)( (int)( ( p1.getY() - y ) * Math.abs( obsZ ) ) / denom1 );
    xp1 = (int)( xp1 * scaleX ) + offsetX;
    yp1 = (int)( yp1 * scaleY ) + offsetY;

    xp2 = (int)( (int)( ( p2.getX() - x ) * Math.abs( obsZ ) ) / denom2 );
    yp2 = (int)( (int)( ( p2.getY() - y ) * Math.abs( obsZ ) ) / denom2 );
    xp2 = (int)( xp2 * scaleX ) + offsetX;
    yp2 = (int)( yp2 * scaleY ) + offsetY;

    if ( xp1 <= xp2 )
    {
      return new int[] { xp1 , yp1 , xp2 , yp2 };
    } else
    {
      return new int[] { xp2 , yp2 , xp1 , yp1 };
    }
  }

  //-----------------------------------------------------------------------------
  public void draw( Graphics g )
  {
    g.drawLine( xp1 , yp1 , xp2 , yp2 );
  }

  //-----------------------------------------------------------------------------
  public Segment rotate( double[][] rotate , double xC , double yC , double zC )
  {
    p1.rotate( rotate , xC , yC , zC );
    p2.rotate( rotate , xC , yC , zC );
    return this;
  }

  //-----------------------------------------------------------------------------
  public int compareTo(Object o)
  {
    Segment s = (Segment)o;
    if ( ( (s.p1.compareTo(p1) == 0) && (s.p2.compareTo(p2) == 0) ) || ( (s.p1.compareTo(p2) == 0) && (s.p2.compareTo(p1) == 0) ) )
    {
      return 0;
    } else return 1;
  }

  //-----------------------------------------------------------------------------
  public boolean equals(Object o)
  {
    if (compareTo( (Segment)o) == 0)
    {
      return true;
    } else return false;
  }

  //-----------------------------------------------------------------------------
  public static int[] equalsProjection(int[] t, int[] s)
  {
    if ( (t == null) && (s == null) ) return null;
    if ( (t == null) && (s != null) ) return s;
    if ( (t != null) && (s == null) ) return t;

    int xMin = Integer.MAX_VALUE, yMin = Integer.MAX_VALUE, xMax = Integer.MIN_VALUE, yMax = Integer.MIN_VALUE;
    double p1 = 0;

    if ( (t[3] - t[1] ) == 0)
    {
      p1 = 0;
    }
    else if ( (t[2] - t[0] ) == 0)
    {
      if (s[0] != s[2] )
      {
        return null;
      } else if (s[0] != t[0] )
      {
        return null;
      } else
      {
        if ( t[1] <= yMin )
        {
          yMin = t[1];
          xMin = t[0];
        }
        if ( t[3] <= yMin )
        {
          yMin = t[3];
          xMin = t[2];
        }
        if ( s[1] <= yMin )
        {
          yMin = s[1];
          xMin = s[0];
        }
        if ( s[3] <= yMin )
        {
          yMin = s[3];
          xMin = s[2];
        }
        if ( t[1] >= yMax )
        {
          yMax = t[1];
          xMax = t[0];
        }
        if ( t[3] >= yMax )
        {
          yMax = t[3];
          xMax = t[2];
        }
        if ( s[1] >= yMax )
        {
          yMax = s[1];
          xMax = s[0];
        }
        if ( s[3] >= yMax )
        {
          yMax = s[3];
          xMax = s[2];
        }
        return new int[] {xMin, yMin, xMax, yMax};
      }
    }
    else
    {
      p1 = ( (double)t[3] - (double)t[1] )/( (double)t[2] - (double)t[0] );
    }

    if ( ( (double)s[1] == (p1 * ( (double)s[0] - (double)t[2] ) + (double)t[3] ) ) && ( (double)s[3] == (p1 * ( (double)s[2] - (double)t[2] ) + (double)t[3] ) ) )
    {
      if ( ( (t[2] >= s[0] ) && (t[0] <= s[0] ) ) || ( (s[2] >= t[0] ) && (s[0] <= t[0] ) ) )
      {
        if ( t[0] <= xMin )
        {
          xMin = t[0];
          yMin = t[1];
        }
        if ( t[2] <= xMin )
        {
          xMin = t[2];
          yMin = t[3];
        }
        if ( s[0] <= xMin )
        {
          xMin = s[0];
          yMin = s[1];
        }
        if ( s[2] <= xMin )
        {
          xMin = s[2];
          yMin = s[3];
        }
        if ( t[0] >= xMax )
        {
          xMax = t[0];
          yMax = t[1];
        }
        if ( t[2] >= xMax )
        {
          xMax = t[2];
          yMax = t[3];
        }
        if ( s[0] >= xMax )
        {
          xMax = s[0];
          yMax = s[1];
        }
        if ( s[2] >= xMax )
        {
          xMax = s[2];
          yMax = s[3];
        }
        return new int[] {xMin, yMin, xMax, yMax};
      }
    }
    return null;
  }

  //-----------------------------------------------------------------------------
  public void setColor(Color color)
  {
    this.color = color;
  }

  //-----------------------------------------------------------------------------
  public Color getColor()
  {
    return color;
  }

  //-----------------------------------------------------------------------------
  public void setP1(Point p)
  {
    p1 = p;
  }

  //-----------------------------------------------------------------------------
  public void setP2(Point p)
  {
    p2 = p;
  }

  //-----------------------------------------------------------------------------
  public Point getP1()
  {
    return (p1);
  }

  //-----------------------------------------------------------------------------
  public Point getP2()
  {
    return (p2);
  }

  //-----------------------------------------------------------------------------
  public boolean isBack(Object[] tab, double x, double y, double z)
  {
    if (tab == null) return false;

    boolean f = false;

    Surface s = null;

    Polygon p = null;

    int nb = 0;

    double p1x = 0, p1y = 0, p1z = 0, p2x = 0, p2y = 0, p2z = 0, px = 0, py = 0, pz = 0;

    for (int j = tab.length - 1; j > 0 ; j--)
    {
      s = ( (Surface)(tab[j] ) );
      p = s.getPolygon();
      p1x = p1.getX(); p2x = p2.getX(); p1y = p1.getY(); p2y = p2.getY(); p1z = p1.getZ(); p2z = p2.getZ();
      px = (p1x + p2x)/2; py = (p1y + p2y)/2; pz = (p1z + p2z)/2;
      if ( ( (x - px)*(x - px) + (y - py)*(y - py) + (z - pz)*(z - pz) ) < Volume.calcDistance(s, x, y, z) )
      {
        continue;
      }
      if ( ( p.contains(xp1, yp1) ) || ( p.contains(xp2, yp2) ) )
      {
        if (nb++ == 2) return true;
      }
    }
    return false;
  }

}


// =============================================================================
// class =======================================================================
// =============================================================================
class Surface implements Comparable, GDG3DTetrisCstes , java.io.Serializable {

  private ArrayList lstPoints;
  private Point middle;
  private Color color;
  private boolean fill;
  private double scalProdX, scalProdY, scalProdZ;
  private Polygon polygon;
  private boolean notDrawPolygonOnDemand = false;

  //-----------------------------------------------------------------------------
  public Surface()
  {
  }

  //-----------------------------------------------------------------------------
  public Surface(Color color)
  {
    lstPoints = new ArrayList();
    if (color == null) this.color = Color.green;
    this.color = color;
    middle = calcMiddlePoint(lstPoints);
    fill = false;
  }

  //-----------------------------------------------------------------------------
  public Surface(Surface s)
  {
    if (!s.lstPoints.isEmpty() )
    {
      setLstPoints(s.getLstPoints() );
    }
    color = s.color;
    fill = s.fill;
    scalProdX = s.scalProdX;
    scalProdY = s.scalProdY;
    scalProdZ = s.scalProdZ;
  }

  //-----------------------------------------------------------------------------
  public Surface(Point[] p, Color color)
  {
    lstPoints = new ArrayList();
    if (color == null) this.color = Color.green;
    this.color = color;
    addPoints(p);
    fill = false;
  }

  //-----------------------------------------------------------------------------
  public void setLstPoints(ArrayList lstPoints)
  {
    if (this.lstPoints == null)
    {
      this.lstPoints = new ArrayList();
    }
    else
    {
      this.lstPoints.clear();
    }
    if (lstPoints.isEmpty() ) return;
    addPoints(lstPoints);
  }

  //-----------------------------------------------------------------------------
  public void addPoint(Point p)
  {
    lstPoints.add(p);
    calcScalarProduct();
    middle = calcMiddlePoint(lstPoints);
  }

  //-----------------------------------------------------------------------------
  public void addPoints(Point[] p)
  {
    int nbPoints = p.length;
    if (nbPoints == 0) return;
    if (lstPoints == null)
    {
      lstPoints = new ArrayList();
    }
    for (int i = 0; i < nbPoints; i++)
    {
      lstPoints.add(new Point(p[i] ) );
    }
    calcScalarProduct();
    middle = calcMiddlePoint(lstPoints);
  }

  //-----------------------------------------------------------------------------
  public void addPoints(ArrayList p)
  {
    if (p.isEmpty() ) return;
    if (lstPoints == null)
    {
      lstPoints = new ArrayList();
    }
    Iterator i = p.iterator();
    while(i.hasNext() )
    {
      lstPoints.add(new Point( (Point)i.next() ));
    }
    calcScalarProduct();
    middle = calcMiddlePoint(lstPoints);
  }

  //-----------------------------------------------------------------------------
  public void clear()
  {
    lstPoints.clear();
    middle = null;
    color = null;
  }

  //-----------------------------------------------------------------------------
  public void setColor(Color color)
  {
    this.color = color;
  }

  //-----------------------------------------------------------------------------
  public Color getColor()
  {
    return color;
  }

  //-----------------------------------------------------------------------------
  public void removePoint(Point p)
  {
    lstPoints.remove(p);
    calcScalarProduct();
    middle = calcMiddlePoint(lstPoints);
  }

  //-----------------------------------------------------------------------------
  public ArrayList getLstPoints()
  {
    return lstPoints;
  }

  //-----------------------------------------------------------------------------
  private static Point calcMiddlePoint(ArrayList lstPoints)
  {
    double xM = 0, yM = 0, zM = 0;
    Point p = null;
    int nbPoints = lstPoints.size();

    if (nbPoints == 0) return null;

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      p = (Point)(iLstPoints.next() );
      xM = xM + p.getX();
      yM = yM + p.getY();
      zM = zM + p.getZ();
    }
    xM /= nbPoints;
    yM /= nbPoints;
    zM /= nbPoints;

    return new Point(xM, yM, zM);
  }

  //-----------------------------------------------------------------------------
  public Point getMiddle()
  {
    if (middle == null) middle = calcMiddlePoint(lstPoints);
    return middle;
  }

  //-----------------------------------------------------------------------------
  public int compareTo(Object o)
  {
    Surface s = (Surface)o;

    if (s == null) return -1;

    if (s.getLstPoints() == null) return -1;

    if (s.getLstPoints().size() != lstPoints.size() ) return 1;

    Point p = null;
    boolean f = true;
    Iterator i = lstPoints.iterator();
    while( (f == true) && i.hasNext() )
    {
      p = (Point)i.next();
      f = false;
      Iterator iS = s.getLstPoints().iterator();
      while(iS.hasNext() )
      {
        if ( p.compareTo( ((Point)iS.next() )) == 0)
        {
          f = true;
          break;
        }
      }
    }

    if (f == true) return 0; else return 1;
  }

  //-----------------------------------------------------------------------------
  public boolean equals(Object o)
  {
    int r = compareTo(o);
    if (r == 0) return true;
    return false;
  }

  //-----------------------------------------------------------------------------
  public Surface translate(double x, double y, double z)
  {
    if (lstPoints == null) return this;

    if (lstPoints.isEmpty() ) return this;

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      ( (Point)iLstPoints.next() ).translate(x, y, z);
    }

    middle.translate(x, y, z);

    return this;
  }

  //-----------------------------------------------------------------------------
  public void setXYZMiddle(double x, double y, double z)
  {
    double distX = x - middle.getX();
    double distY = y - middle.getY();
    double distZ = z - middle.getZ();

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      ( (Point)iLstPoints.next() ).translate(distX, distY, distZ);
    }
    middle.setXYZ(x, y, z);
  }

  //-----------------------------------------------------------------------------
  public Surface rotate(double[][] rotate, double xC, double yC, double zC)
  {
    if (lstPoints == null) return this;

    if (lstPoints.isEmpty() ) return this;

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      ( (Point)iLstPoints.next() ).rotate(rotate, xC, yC, zC);
    }

    calcScalarProduct();
    middle.rotate(rotate, xC, yC, zC);

    return this;
  }

  //-----------------------------------------------------------------------------
  public void setFill()
  {
    fill = true;
  }

  public void unSetFill()
  {
    fill = false;
  }

  public boolean isFill()
  {
    return(fill);
  }

  //-----------------------------------------------------------------------------
  public void calcPolygon(double obsZ, double x, double y, double z, double scaleX, double scaleY, int offsetX, int offsetY)
  {
    if ( (lstPoints == null) || (lstPoints.isEmpty() ) ) return;

    int xp = 0, yp = 0;
    Point p = null;
    polygon = new Polygon();

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      p = (Point)iLstPoints.next();
      if ( (p.getZ() - z) <= 0 )
      {
        continue;
      }
      int denom = (int)(p.getZ() - z + Math.abs(obsZ) );
      if ( denom == 0 )
      {
        continue;
      }
      xp = (int)( (int)( (p.getX() - x) * Math.abs(obsZ) ) / denom);
      yp = (int)( (int)( (p.getY() - y) * Math.abs(obsZ) ) / denom);
      xp = (int)(xp * scaleX) + offsetX;
      yp = (int)(yp * scaleY) + offsetY;

      polygon.addPoint(xp, yp);
      p = null;
    }
    return;
  }


  //-----------------------------------------------------------------------------
  public void drawPolygon(Graphics g, Color xColor)
  {
    if (polygon == null) return;

    if (xColor != null) g.setXORMode(xColor);

    if ( (fill == true) && (xColor == null) )
    {
      Color c = g.getColor();
      g.setColor(color);
      g.fillPolygon(polygon);
      g.setColor(Color.black);
      g.drawPolygon(polygon);
      g.setColor( c );
    }
    else
    {
      Color c = g.getColor();
      g.setColor(color);
      g.drawPolygon(polygon);
      g.setColor( c );
    }
    if (xColor != null) g.setPaintMode();
  }

  //-----------------------------------------------------------------------------
  public Polygon getPolygon()
  {
    return polygon;
  }

  //-----------------------------------------------------------------------------
  public boolean isBack(Object[] tab, double x, double y, double z)
  {
    if (tab == null) return false;
    boolean f = false;

    Surface s = null;

    Polygon p = null;

    int nb = 0;

    l: for (int j = tab.length - 1; j > 0 ; j--)
    {
      s = ( (Surface)(tab[j] ) );
      p = s.getPolygon();
      if (Volume.calcDistance(this, x, y, z) < Volume.calcDistance(s, x, y, z) )
      {
        continue;
      }
      for (int k = 0; k < polygon.npoints; k++)
      {
        if ( p.contains(polygon.xpoints[k], polygon.ypoints[k] ) )
        {
          if (++nb == polygon.npoints)
          {
            return true;
          }
        }
      }
    }
    return false;
  }

  //-----------------------------------------------------------------------------
  public double getScalarProductX()
  {
    return scalProdX;
  }

  //-----------------------------------------------------------------------------
  public double getScalarProductY()
  {
    return scalProdY;
  }

  //-----------------------------------------------------------------------------
  public double getScalarProductZ()
  {
    return scalProdZ;
  }

  //-----------------------------------------------------------------------------
  public void calcScalarProduct()
  {
    Point p1 = (Point)lstPoints.get(0);
    Point p2 = (Point)lstPoints.get(1);
    Point p3 = (Point)lstPoints.get(2);
    double p1x = p1.getX(), p1y = p1.getY(), p1z = p1.getZ();
    double p2x = p2.getX(), p2y = p2.getY(), p2z = p2.getZ();
    double p3x = p3.getX(), p3y = p3.getY(), p3z = p3.getZ();
    scalProdX = ( ( (p2y - p1y) * (p1z - p3z) ) - ( (p2z - p1z) * (p1y - p3y) ) );
    scalProdY = ( ( (p2z - p1z) * (p1x - p3x) ) - ( (p2x - p1x) * (p1z - p3z) ) );
    scalProdZ = ( ( (p2x - p1x) * (p1y - p3y) ) - ( (p2y - p1y) * (p1x - p3x) ) );
  }

  //-----------------------------------------------------------------------------
  public void setNotDrawPolygonOnDemand(boolean f)
  {
    notDrawPolygonOnDemand = f;
  }

  //-----------------------------------------------------------------------------
  public boolean getNotDrawPolygonOnDemand()
  {
    return notDrawPolygonOnDemand;
  }

  //-----------------------------------------------------------------------------
  public void finalize()
  {
    if (lstPoints == null) return;

    if (lstPoints.isEmpty() ) return;

    Iterator iLstPoints = lstPoints.iterator();
    while(iLstPoints.hasNext() )
    {
      ( (Surface)iLstPoints.next() ).finalize();
    }
    lstPoints.clear();

    middle = null;

    color = null;
  }

}


// =============================================================================
// class =======================================================================
// =============================================================================
class Volume implements Comparable , GDG3DTetrisCstes , java.io.Serializable {

  private ArrayList lstSurfaces;
  Object[] tabSurfacesToDraw;
  private ArrayList lstMiddles;
  private ArrayList lstSegments;
  private Point middle;
  private Point PXminYminZmin;
  private Point PXmaxYmaxZmax;
  private Point PXminYmaxZmin;
  private Point PXminYmaxZmax;
  private Point PXminYminZmax;
  private Point PXmaxYminZmin;
  private Point PXmaxYmaxZmin;
  private Point PXmaxYminZmax;
  private int nbStages;
  private int[] stages;
  private int nbPerStages;

  private Color color;

  private boolean fill;

  private double tetaX, tetaY, tetaZ;
  private double tetaXOld = 1, tetaYOld = 1, tetaZOld = 1;
  private double Cx, Cy, Cz, Sx, Sy, Sz;
  private double[][] rotate = new double[3][3];

  private double obsX = Integer.MIN_VALUE, obsY = Integer.MIN_VALUE, obsZ = Integer.MIN_VALUE;

  private boolean calculateForNewPosition;


  //-----------------------------------------------------------------------------
  private void calcLstSegments()
  {
    if (lstSurfaces == null) return;

    if (lstSurfaces.isEmpty() ) return;

    if (lstSegments == null) lstSegments = new ArrayList();

    boolean f = false;

    Surface s = null;

    Point p1 = null, p2 = null;

    Segment seg = null;

    Color c = null;

    int nb1 = 0 , nb2 = 0 , nb3 = 0;

    Iterator is = null;
    Iterator ils = null;
    Iterator i = lstSurfaces.iterator();
    while (i.hasNext() )
    {
      f = false;
      s = (Surface)i.next();
      c = s.getColor();
      is = s.getLstPoints().iterator();
      p1 = (Point)is.next();
      while (is.hasNext() )
      {
        p2 = (Point)is.next();
        seg = new Segment(p1, p2, c);
        if (lstSegments.isEmpty() )
        {
          lstSegments.add(seg);
          p1 = p2;
          continue;
        }
        f = false;
        ils = lstSegments.iterator();
        while (ils.hasNext() )
        {
          if ( ((Segment)ils.next() ).compareTo(seg) == 0)
          {
            f = true;
            break;
          }
        }
        if (f == false)
        {
          lstSegments.add(seg);
        }
        p1 = p2;
      }
      p2 = (Point)s.getLstPoints().get(0);
      seg = new Segment(p1, p2, c);
      f = false;
      ils = lstSegments.iterator();
      while (ils.hasNext() )
      {
        if ( ((Segment)ils.next() ).compareTo(seg) == 0)
        {
          f = true;
          break;
        }
      }
      if (f == false)
      {
        lstSegments.add(seg);
      }
    }

    int nb11 = 0 , nb12 = 0 , nb13 = 0 , nb14 = 0 ,
        nb21 = 0 , nb22 = 0 , nb23 = 0 , nb24 = 0 ,
        nb31 = 0 , nb32 = 0 , nb33 = 0 , nb34 = 0;
    ArrayList lstSegments2 = new ArrayList();
    Segment s1 = null, s2 = null, s3 = null;
    Point s1p1 = null, s1p2 = null, s2p1 = null, s2p2 = null;
    int ind1 = 0, ind2 = 0;
    ListIterator li1 = lstSegments.listIterator(), li2 = null;
    while (li1.hasNext() )
    {
      ind1 = li1.nextIndex();
      s1 = (Segment)li1.next();
      if (s1 == null)
      {
        li1.remove();
        continue;
      }
      s1p1 = s1.getP1(); s1p2 = s1.getP2();
      li2 = lstSegments.listIterator();
      while (li2.hasNext() )
      {
        ind2 = li2.nextIndex();
        if (ind2 == ind1)
        {
          li2.next();
          continue;
        }
        s2 = (Segment)li2.next();
        if (s2 == null) continue;
        s2p1 = s2.getP1(); s2p2 = s2.getP2();
        s3 = null;
        if ( ( s1p1.getX() == s1p2.getX() ) && ( s2p1.getX() == s2p2.getX() ) && ( s1p1.getX() == s2p1.getX() ) &&
             ( s1p1.getY() == s1p2.getY() ) && ( s2p1.getY() == s2p2.getY() ) && ( s1p1.getY() == s2p1.getY() ) )
        {
          if ( s1p2.getZ() == s2p1.getZ() )
          {
            s3 = new Segment(s1p1, s2p2, s1.getColor() );
            nb11++;
          } else if ( s1p1.getZ() == s2p2.getZ() )
          {
            s3 = new Segment(s1p2, s2p1, s1.getColor() );
            nb12++;
          } else if ( s1p1.getZ() == s2p1.getZ() )
          {
            s3 = new Segment(s1p2, s2p2, s1.getColor() );
            nb13++;
          } else if ( s1p2.getZ() == s2p2.getZ() )
          {
            s3 = new Segment(s1p1, s2p1, s1.getColor() );
            nb14++;
          }
        } else if ( ( s1p1.getY() == s1p2.getY() ) && ( s2p1.getY() == s2p2.getY() ) && ( s1p1.getY() == s2p1.getY() ) &&
                    ( s1p1.getZ() == s1p2.getZ() ) && ( s2p1.getZ() == s2p2.getZ() ) && ( s1p1.getZ() == s2p1.getZ() ) )
        {
          if ( s1p2.getX() == s2p1.getX() )
          {
            s3 = new Segment(s1p1, s2p2, s1.getColor() );
            nb21++;
          } else if ( s1p1.getX() == s2p2.getX() )
          {
            s3 = new Segment(s1p2, s2p1, s1.getColor() );
            nb22++;
          } else if ( s1p1.getX() == s2p1.getX() )
          {
            s3 = new Segment(s1p2, s2p2, s1.getColor() );
            nb23++;
          } else if ( s1p2.getX() == s2p2.getX() )
          {
            s3 = new Segment(s1p1, s2p1, s1.getColor() );
            nb24++;
          }
        } else if ( ( s1p1.getX() == s1p2.getX() ) && ( s2p1.getX() == s2p2.getX() ) && ( s1p1.getX() == s2p1.getX() ) &&
                    ( s1p1.getZ() == s1p2.getZ() ) && ( s2p1.getZ() == s2p2.getZ() ) && ( s1p1.getZ() == s2p1.getZ() ) )
        {
          if ( s1p2.getY() == s2p1.getY() )
          {
            s3 = new Segment(s1p1, s2p2, s1.getColor() );
            nb31++;
          } else if ( s1p1.getY() == s2p2.getY() )
          {
            s3 = new Segment(s1p2, s2p1, s1.getColor() );
            nb32++;
          } else if ( s1p1.getY() == s2p1.getY() )
          {
            s3 = new Segment(s1p2, s2p2, s1.getColor() );
            nb33++;
          } else if ( s1p2.getY() == s2p2.getY() )
          {
            s3 = new Segment(s1p1, s2p1, s1.getColor() );
            nb34++;
          }
        }
        if (s3 != null)
        {
          li2.set(null);
          s1 = s3;
        }
      }
      li1.set(null);
      lstSegments2.add(s1);
    }

    Collections.copy(lstSegments, lstSegments2);
  }

  //-----------------------------------------------------------------------------
  public Volume()
  {
  }

  //-----------------------------------------------------------------------------
  public Volume(Volume v)
  {
    if (v == null) return;
    if (!v.lstSurfaces.isEmpty() )
    {
      setLstSurfaces(v.getLstSurfaces() );
    }

    middle = new gdg3dtetris.Point( ( gdg3dtetris.Point )v.getMiddle() );

    fill = v.fill;

    tetaX = v.tetaX;
    tetaY = v.tetaY;
    tetaZ = v.tetaZ;

    Cx = v.Cx; Cy = v.Cy; Cz = v.Cz;
    Sx = v.Sx; Sy = v.Sy; Sz = v.Sz;

    for (int i = 0; i < v.rotate.length; i++)
    {
      for (int j = 0; j < v.rotate[i].length; j++)
      {
        rotate[i][j] = v.rotate[i][j];
      }
    }

    PXmaxYmaxZmax = v.PXmaxYmaxZmax;
    PXmaxYmaxZmin = v.PXmaxYmaxZmin;
    PXmaxYminZmax = v.PXmaxYminZmax;
    PXmaxYminZmin = v.PXmaxYminZmin;
    PXminYmaxZmax = v.PXminYmaxZmax;
    PXminYmaxZmin = v.PXminYmaxZmin;
    PXminYminZmax = v.PXminYminZmax;
    PXminYminZmin = v.PXminYminZmin;

    nbStages = v.nbStages;

    nbPerStages = v.nbPerStages;

    stages = new int[ nbStages ];
    for( int i = 0 ; i < nbStages ; i++ )
    {
            stages[ i ] = v.stages[ i ];
    }

  }

  //-----------------------------------------------------------------------------
  public Volume( short[][][] model , Color color , boolean eraseSameSurfaces , boolean splice )
  {
    lstSurfaces = new ArrayList();
    lstMiddles = new ArrayList();
    ArrayList lstS = null;
    short m = 0;
    int offset = OFFSET;

    for (int x = 0; x < model.length; x++)
    {
      for (int y = 0; y < model[x].length; y++)
      {
        for (int z = 0; z < model[x][y].length; z++)
        {
          m = model[x][y][z];
          switch (m)
          {
            case CODE_CUBE_EN_0_0_0 :
            {
              java.util.List l = Arrays.asList(new Surface[] { (new Surface(CUBE_EN_0_0_0[0] ) ).translate(x*COTE_CARRE + x*2*offset - offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset),
                                          (new Surface(CUBE_EN_0_0_0[1] ) ).translate(x*COTE_CARRE + x*2*offset + offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset),
                                          (new Surface(CUBE_EN_0_0_0[2] ) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset - offset, z*COTE_CARRE + z*2*offset),
                                          (new Surface(CUBE_EN_0_0_0[3] ) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset + offset, z*COTE_CARRE + z*2*offset),
                                          (new Surface(CUBE_EN_0_0_0[4] ) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset - offset),
                                          (new Surface(CUBE_EN_0_0_0[5] ) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset + offset),
                                        });
              addSurfaces( l , eraseSameSurfaces , false , false , splice );
              addMiddle(calcMiddlePoint(l) );
              break;
            }
            default :
            {
              lstS = new ArrayList();
              if ( (m & CODE_CARRE_ParallelToYZPlan_XNull) != 0)
              {
                lstS.add( (new Surface(CARRE_ParallelToYZPlan_XNull) ).translate(x*COTE_CARRE + x*2*offset - offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset) );
              }
              if ( (m & CODE_CARRE_ParallelToYZPlan_XNotNull) != 0)
              {
                lstS.add( (new Surface(CARRE_ParallelToYZPlan_XNotNull) ).translate(x*COTE_CARRE + x*2*offset + offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset) );
              }
              if ( (m & CODE_CARRE_ParallelToXYPlan_ZNull) != 0)
              {
                lstS.add( (new Surface(CARRE_ParallelToXYPlan_ZNull) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset - offset) );
              }
              if ( (m & CODE_CARRE_ParallelToXYPlan_ZNotNull) != 0)

              {
                lstS.add( (new Surface(CARRE_ParallelToXYPlan_ZNotNull) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset, z*COTE_CARRE + z*2*offset + offset) );
              }
              if ( (m & CODE_CARRE_ParallelToXZPlan_YNull) != 0)
              {
                lstS.add( (new Surface(CARRE_ParallelToXZPlan_YNull) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset - offset, z*COTE_CARRE + z*2*offset) );
              }
              if ( (m & CODE_CARRE_ParallelToXZPlan_YNotNull) != 0)
              {
                lstS.add( (new Surface(CARRE_ParallelToXZPlan_YNotNull) ).translate(x*COTE_CARRE + x*2*offset, y*COTE_CARRE + y*2*offset + offset, z*COTE_CARRE + z*2*offset) );
              }
            }
          }
          if ( (lstS != null) && (!lstS.isEmpty() ) )
          {
            addSurfaces( lstS , eraseSameSurfaces , false , false , splice );
            addMiddle( calcMiddlePoint( lstS ) );
            lstS.clear();
          }
        }
      }
    }
    calcMiddlePointOfVolume();
    setColor(color);
    calcLimits();
  }

  //-----------------------------------------------------------------------------
  public void setLstMiddles(ArrayList p)
  {
    if (lstMiddles == null)
    {
      lstMiddles = new ArrayList();
    }
    else
    {
      lstMiddles.clear();
    }
    addMiddles(p);
  }

  //-----------------------------------------------------------------------------
  public void addMiddle(Point p)
  {
    if (lstMiddles == null)
    {
      lstMiddles = new ArrayList();
    }
    lstMiddles.add(p);
  }

  //-----------------------------------------------------------------------------
  public void addMiddles(Point[] p)
  {
    int nbMiddles = p.length;
    if (nbMiddles == 0) return;
    if (lstMiddles == null)
    {
      lstMiddles = new ArrayList();
    }
    for (int i = 0; i < nbMiddles; i++)
    {
      lstMiddles.add(new Point(p[i] ) );
    }
  }

  //-----------------------------------------------------------------------------
  public void addMiddles( ArrayList p )
  {
    if ( p.isEmpty() ) return;
    Point point = null;
    if ( lstMiddles == null )
    {
      lstMiddles = new ArrayList();
    }
    Iterator i = p.iterator();
    while( i.hasNext() )
    {
      point = (Point)i.next();
      lstMiddles.add( new Point(point) );
      int a = nbStages - (int)( ( point.getZ() - GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION + GDG3DTetrisCstes.COTE_CARRE ) / GDG3DTetrisCstes.COTE_CARRE );
      stages[a]++;
    }
  }

  //-----------------------------------------------------------------------------
  public boolean eraseStage()
  {
    ListIterator lis = null , lim = null;

    double zMid = 0;

    Surface s = null;

    Point p = null;

    if ( stages[ nbStages - 1 ] != 0 )
    {
      return( false );
    }

    for ( int z = 0 ; z < stages.length ; z++ )
    {
      if ( stages[z] == nbPerStages )
      {
        if ( ( lim = lstMiddles.listIterator() ) != null )
        {
          while( lim.hasNext() )
          {
            zMid = ( (Point)lim.next() ).getZ() - GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION;
            if ( zMid == ( nbStages - z - 1 ) * GDG3DTetrisCstes.COTE_CARRE + GDG3DTetrisCstes.COTE_CARRE/2 )
            {
              lim.remove();
            }
          }
          lim = lstMiddles.listIterator();
          while( lim.hasNext() )
          {
            p = (Point)lim.next();
            zMid = p.getZ() - GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION;
            if ( zMid < ( nbStages - z - 1 ) * GDG3DTetrisCstes.COTE_CARRE )
            {
              p.translate( 0 , 0 , GDG3DTetrisCstes.COTE_CARRE );
            }
          }
        }
        lis = lstSurfaces.listIterator();
        while( lis.hasNext() )
        {
          s = (Surface)lis.next();
          zMid = s.getMiddle().getZ() - GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION;
          if ( ( zMid == ( nbStages - z ) * GDG3DTetrisCstes.COTE_CARRE - GDG3DTetrisCstes.COTE_CARRE/2 )
                ||
               ( zMid == ( nbStages - z - 1 ) * GDG3DTetrisCstes.COTE_CARRE )
                ||
               ( ( zMid == ( nbStages - z ) * GDG3DTetrisCstes.COTE_CARRE ) && ( s.getScalarProductZ() > 0 ) ) )
          {
            lis.remove();
          } else if ( zMid < (nbStages - z - 1) * GDG3DTetrisCstes.COTE_CARRE )
          {
            s.translate( 0 , 0 , GDG3DTetrisCstes.COTE_CARRE );
          }
        }
        for( int i = z ; i < nbStages - 1 ; i++ )
        {
          stages[i] = stages[ i + 1 ];
        }
        stages[ nbStages - 1 ] = 0;
        z--;
      }
    }
    return( true );
  }

  //-----------------------------------------------------------------------------
  public void setLstSurfaces(ArrayList s)
  {
    if (lstSurfaces == null)
    {
      lstSurfaces = new ArrayList();
    }
    else
    {
      lstSurfaces.clear();
    }
    addSurfaces( s , true , true , false , false );
  }

  //-----------------------------------------------------------------------------
  public void addSurface(Surface s)
  {
    if (lstSurfaces == null)
    {
      lstSurfaces = new ArrayList();
    }
    lstSurfaces.add(s);
  }

  //-----------------------------------------------------------------------------
  public void addSurfaces( Object[] s , boolean erase , boolean cloneEachSurface , boolean soil , boolean splice )
  {
    boolean f = true;
    int nbSurfaces;

    if ( ( nbSurfaces = s.length ) == 0 ) return;

    if ( lstSurfaces == null )
    {
      lstSurfaces = new ArrayList();
    }
    for ( int i = 0; i < nbSurfaces; i++ )
    {
      if ( ( soil ) &&
              ( ( (Surface)s[i] ).getMiddle().getZ() - GDG3DTetrisCstes.OFFSET_FOR_GOOD_PRECISION == ( nbStages - 1 ) * GDG3DTetrisCstes.COTE_CARRE ) )
      {
        continue;
      }

      f = true;

      if ( erase == true )
      {
        ListIterator iLstSurfaces = lstSurfaces.listIterator();
        Surface sf;
        while (iLstSurfaces.hasNext() )
        {
          if ( ( sf = (Surface)iLstSurfaces.next() ).compareTo( s[i] ) == 0 )
          {
            f = false;
            if ( ( (Surface)s[i] ).getScalarProductZ() != 0 )
            {
              f = true;
            }
            if ( ( splice == true ) && ( sf.getScalarProductZ() == 0 ) )
            {
              iLstSurfaces.remove();
            }
            break;
          }
        }
      }
      if (f == true)
      {
        lstSurfaces.add( cloneEachSurface ? new Surface( (Surface)s[i] ) : s[i] );
      }
    }
  }

  //-----------------------------------------------------------------------------
  public void addSurfaces( java.util.List s , boolean erase , boolean cloneEachSurface , boolean soil , boolean splice )
  {
    addSurfaces( s.toArray() , erase , cloneEachSurface , soil , splice );
  }

  //-----------------------------------------------------------------------------
  public void clear()
  {
    if (lstSurfaces != null) lstSurfaces.clear();
    middle = null;
  }

  //-----------------------------------------------------------------------------
  public void removeSurface(Surface s)
  {
    if (lstSurfaces == null) return;
    lstSurfaces.remove(s);
  }

  //-----------------------------------------------------------------------------
  public ArrayList getLstSurfaces()
  {
    return lstSurfaces;
  }

  //-----------------------------------------------------------------------------
  public ArrayList getLstMiddles()
  {
    return lstMiddles;
  }

  //-----------------------------------------------------------------------------
  public Object[] getTabSurfacesToDraw()
  {
    return tabSurfacesToDraw;
  }

  //-----------------------------------------------------------------------------
  public void calcLimits()
  {
    Surface s = null;
    Point p = null;

    double xMax = Integer.MIN_VALUE, yMax = Integer.MIN_VALUE, zMax = Integer.MIN_VALUE,
           xMin = Integer.MAX_VALUE, yMin = Integer.MAX_VALUE, zMin = Integer.MAX_VALUE;

    double x = 0, y = 0, z = 0;

    Iterator ilstS = lstSurfaces.iterator();
    while (ilstS.hasNext() )
    {
      s = (Surface)ilstS.next();
      Iterator ilstP = s.getLstPoints().iterator();
      while (ilstP.hasNext() )
      {
        p = (Point)ilstP.next();
        x = p.getX(); y = p.getY(); z = p.getZ();
        if (x < xMin)
        {
          xMin = x;
        } else if (x > xMax)
        {
          xMax = x;
        }
        if (y < yMin)
        {
          yMin = y;
        } else if (y > yMax)
        {
          yMax = y;
        }
        if (z < zMin)
        {
          zMin = z;
        } else if (z > zMax)
        {
          zMax = z;
        }
      }
    }

    PXminYminZmin = new Point(xMin, yMin, zMin);
    PXmaxYmaxZmax = new Point(xMax, yMax, zMax);
    PXminYmaxZmin = new Point(xMin, yMax, zMin);
    PXminYmaxZmax = new Point(xMin, yMax, zMax);
    PXminYminZmax = new Point(xMin, yMin, zMax);
    PXmaxYminZmin = new Point(xMax, yMin, zMin);
    PXmaxYmaxZmin = new Point(xMax, yMax, zMin);
    PXmaxYminZmax = new Point(xMax, yMin, zMax);
  }

  //-----------------------------------------------------------------------------
  public int getNbPerStages()
  {
    return nbPerStages;
  }

  //-----------------------------------------------------------------------------
  public int getNbStages()
  {
    return nbStages;
  }

  //-----------------------------------------------------------------------------
  public int[] getStages()
  {
    return stages;
  }

  //-----------------------------------------------------------------------------
  public Point getPXminYminZmin()
  {
    return(PXminYminZmin);
  }

  //-----------------------------------------------------------------------------
  public Point getPXmaxYmaxZmax()
  {
    return(PXmaxYmaxZmax);
  }

  //-----------------------------------------------------------------------------
  public Point getPXminYmaxZmin()
  {
    return(PXminYmaxZmin);
  }

  //-----------------------------------------------------------------------------
  public Point getPXminYmaxzMax()
  {
    return(PXminYmaxZmax);
  }

  //-----------------------------------------------------------------------------
  public Point getPXminYminZmax()
  {
    return(PXminYminZmax);
  }

  //-----------------------------------------------------------------------------
  public Point getPXmaxYminZmin()
  {
    return(PXmaxYminZmin);
  }

  //-----------------------------------------------------------------------------
  public Point getPXmaxYmaxZmin()
  {
    return(PXmaxYmaxZmin);
  }

  //-----------------------------------------------------------------------------
  public Point getPXmaxYminZmax()
  {
    return(PXmaxYminZmax);
  }

  //-----------------------------------------------------------------------------
  public int compareTo(Object o)
  {
    Volume v = (Volume)o;

    if ( (lstSurfaces == null) && (v == null) ) return 0;

    if ( (lstSurfaces == null) && (v != null) ) return 1;

    if ( (lstSurfaces != null) && (v == null) ) return 1;

    if (v.getLstSurfaces().size() != lstSurfaces.size() ) return 1;

    if (v.getMiddle().compareTo(middle) != 0) return 1;

    Iterator i = lstMiddles.iterator();
    Iterator iS = v.getLstMiddles().iterator();
    while(i.hasNext() )
    {
      if ( ( (Point)i.next() ).compareTo( ((Point)iS.next() )) != 0) return 1;
    }

    return 0;
  }

  //-----------------------------------------------------------------------------
  public void calcMiddlePointOfVolume()
  {
    middle = calcMiddlePoint(lstSurfaces);
  }

  //-----------------------------------------------------------------------------
  private static Point calcMiddlePoint(java.util.List lstSurfaces)
  {
    if (lstSurfaces == null) return null;

    double xM = 0, yM = 0, zM = 0;
    Point p = null;
    int nbSurfaces = lstSurfaces.size();

    if (nbSurfaces == 0) return null;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      p = ( (Surface)iLstSurfaces.next() ).getMiddle();
      xM = xM + p.getX();
      yM = yM + p.getY();
      zM = zM + p.getZ();
    }
    xM /= nbSurfaces;
    yM /= nbSurfaces;
    zM /= nbSurfaces;

    return new Point(xM, yM, zM);
  }

  //-----------------------------------------------------------------------------
  public void recentMiddle()
  {
    double dMin = Double.MAX_VALUE;
    double dX = 0, dY = 0, dZ = 0, d = 0;
    Point p = null, pp = null;

    Iterator ilstMiddles = lstMiddles.iterator();
    while(ilstMiddles.hasNext() )
    {
      p = (Point)ilstMiddles.next();
      dX = middle.getX() - p.getX();
      dY = middle.getY() - p.getY();
      dZ = middle.getZ() - p.getZ();
      d = dX*dX + dY*dY + dZ*dZ;
      if ( d < dMin)
      {
        dMin = d;
        pp = p;
      }
    }
    middle = new Point(pp);
  }

  //-----------------------------------------------------------------------------
  public Point getMiddle()
  {
    return middle;
  }

  //-----------------------------------------------------------------------------
  public Volume translate(double x, double y, double z)
  {
    if (lstSurfaces == null) return this;

    if (lstSurfaces.isEmpty() ) return this;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      ( (Surface)iLstSurfaces.next() ).translate(x, y, z);
    }

    Iterator iLstMiddles = lstMiddles.iterator();
    while(iLstMiddles.hasNext() )
    {
      ( (Point)iLstMiddles.next() ).translate(x, y, z);
    }

    middle.translate(x, y, z);

    return this;
  }

  //-----------------------------------------------------------------------------
  public Volume translateX(double x)
  {
    return translate(x, 0, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateY(double y)
  {
    return translate(0, y, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateZ(double z)
  {
    return translate(0, 0, z);
  }

  //-----------------------------------------------------------------------------
  public Volume translateXPlusOneUnit()
  {
    return translate(COTE_CARRE + OFFSET * 2, 0, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateYPlusOneUnit()
  {
    return translate(0, COTE_CARRE + OFFSET * 2, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateZPlusOneUnit()
  {
    return translate(0, 0, COTE_CARRE + OFFSET * 2);
  }

  //-----------------------------------------------------------------------------
  public Volume translateXMinusOneUnit()
  {
    return translate(-COTE_CARRE - OFFSET * 2, 0, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateYMinusOneUnit()
  {
    return translate(0, -COTE_CARRE - OFFSET * 2, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume translateZMinusOneUnit()
  {
    return translate(0, 0, -COTE_CARRE - OFFSET * 2);
  }

  //-----------------------------------------------------------------------------
  public void setXYZMiddle(double x, double y, double z)
  {
    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      ( (Surface)iLstSurfaces.next() ).setXYZMiddle(x, y, z);
    }
    middle.setXYZ(x, y, z);
  }

  //-----------------------------------------------------------------------------
  public Volume rotate(double tetaX, double tetaY, double tetaZ)
  {
    if (lstSurfaces == null) return this;

    if (lstSurfaces.isEmpty() ) return this;

    calcRotationMatrix(tetaX, tetaY, tetaZ);

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      ( (Surface)iLstSurfaces.next() ).rotate(rotate, middle.getX(), middle.getY(), middle.getZ() );
    }

    if ( lstMiddles != null )
    {
      Iterator iLstMiddles = lstMiddles.iterator();
      while(iLstMiddles.hasNext() )
      {
        ( (Point)iLstMiddles.next() ).rotate(rotate, middle.getX(), middle.getY(), middle.getZ() );
      }
    }

    if ( middle != null ) middle.rotate(rotate, middle.getX(), middle.getY(), middle.getZ() );

    return this;
  }

  //-----------------------------------------------------------------------------
  public Volume rotatePlus90Deg_OX()
  {
    return rotate(Math.PI/2, 0, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume rotateMoins90Deg_OX()
  {
    return rotate(-Math.PI/2, 0, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume rotatePlus90Deg_OY()
  {
    return rotate(0, Math.PI/2, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume rotateMoins90Deg_OY()
  {
    return rotate(0, -Math.PI/2, 0);
  }

  //-----------------------------------------------------------------------------
  public Volume rotatePlus90Deg_OZ()
  {
    return rotate(0, 0, Math.PI/2);
  }

  //-----------------------------------------------------------------------------
  public Volume rotateMoins90Deg_OZ()
  {
    return rotate(0, 0, -Math.PI/2);
  }

  //-----------------------------------------------------------------------------
  private void calcRotationMatrix(double tX, double tY, double tZ)
  {
    tetaX = tX;
    tetaY = tY;
    tetaZ = tZ;

    if (tetaX != tetaXOld)
    {
      Cx = StrictMath.cos(tetaX);
      Sx = StrictMath.sin(tetaX);
      tetaXOld = tetaX;
    }
    if (tetaY != tetaYOld)
    {
      Cy = StrictMath.cos(tetaY);
      Sy = StrictMath.sin(tetaY);
      tetaYOld = tetaY;
    }
    if (tetaZ != tetaZOld)
    {
      Cz = StrictMath.cos(tetaZ);
      Sz = StrictMath.sin(tetaZ);
      tetaZOld = tetaZ;
    }

    // Cz*Cy
    rotate[0][0] = Cz*Cy;
    // Sz*Cy
    rotate[0][1] = Sz*Cy;
    // -Sy
    rotate[0][2] = -Sy;

    // Cz*Sy*Sx-Sz*Cx
    rotate[1][0] = Cz*Sy*Sx-Sz*Cx;
    // Sz*Sy*Sx+Cz*Cx
    rotate[1][1] = Sz*Sy*Sx+Cz*Cx;
    // Sx*Cy
    rotate[1][2] = Sx*Cy;

    // Cz*Sy*Cx+Sz*Sx
    rotate[2][0] = Cz*Sy*Cx+Sz*Sx;
    // Sz*Sy*Cx-Cz*Sx
    rotate[2][1] = Sz*Sy*Cx-Cz*Sx;
    // Cx*Cy
    rotate[2][2] = Cx*Cy;
  }

  //-----------------------------------------------------------------------------
  public void setFill()
  {
    fill = true;

    if (lstSurfaces != null)
    {
      Iterator i = lstSurfaces.iterator();
      while(i.hasNext() )
      {
        ( (Surface)i.next() ).setFill();
      }
    }
  }

  //-----------------------------------------------------------------------------
  public void unSetFill()
  {
    fill = false;

    if (lstSurfaces != null)
    {
      Iterator i = lstSurfaces.iterator();
      while(i.hasNext() )
      {
        ( (Surface)i.next() ).unSetFill();
      }
    }
  }

  //-----------------------------------------------------------------------------
  public boolean isFill()
  {
    return(fill);
  }

  //-----------------------------------------------------------------------------
  public void drawMiddle(Graphics g, double obsZ, double x, double y, double z, double scaleX, double scaleY, int offsetX, int offsetY, Color xColor)
  {
    g.setColor(Color.green);
    middle.draw(g, obsZ, x, y, z, scaleX, scaleY, offsetX, offsetY, xColor);
  }

  //-----------------------------------------------------------------------------
  public void draw(Graphics g, double obsZ, double x, double y, double z, double scaleX, double scaleY, int offsetX, int offsetY, Color xColor, Volume v)
  {
    if ( (lstSurfaces == null) || (lstSurfaces.isEmpty() ) ) return;

    Surface s = null;

    int nb = 0;

    if (isFill() )
    {
      if ( calculateForNewPosition == true )
      {
        calculateForNewPosition = false;
        calcSurfacesToDraw(x, y, z);
        for (int i = 0; i < tabSurfacesToDraw.length ; i++)
        {
          ( (Surface)tabSurfacesToDraw[i] ).calcPolygon(obsZ, x, y, z, scaleX, scaleY, offsetX, offsetY);
        }
        Polygon p = null;
        boolean f = true;
        for (int i = 0; i < tabSurfacesToDraw.length ; i++)
        {
          s = ( (Surface)tabSurfacesToDraw[i] );
          p = s.getPolygon();
          f = false;
          nb = 0;
          l: for (int j = tabSurfacesToDraw.length - 1; j > i ; j--)
          {
            for (int k = 0; k < p.npoints; k++)
            {
              /*if ( ! ( (Surface)(tabSurfacesToDraw[j] ) ).getPolygon().contains(p.xpoints[k], p.ypoints[k] ) )
              {
                continue l;
              }*/
              if ( ( (Surface)(tabSurfacesToDraw[j] ) ).getPolygon().contains(p.xpoints[k], p.ypoints[k] ) )
              {
                if (++nb == p.npoints)
                {
                  f = true;
                  break;
                }
              } else continue l;
            }
            f = true;
            break;
          }
          if (f == false)
          {
            if ( (v != null) && (s.isBack(v.getTabSurfacesToDraw(), x, y, z) ) )
            {
              continue;
            }
            s.drawPolygon( g, xColor );
            s.setNotDrawPolygonOnDemand(false);
          }
          else
          {
            s.setNotDrawPolygonOnDemand(true);
          }
        }
      }
      else
      {
        for (int i = 0; i < tabSurfacesToDraw.length ; i++)
        {
          s = ( (Surface)tabSurfacesToDraw[i] );
          if ( (v != null) && (s.isBack(v.getTabSurfacesToDraw(), x, y, z) ) )
          {
            continue;
          }
          if (! s.getNotDrawPolygonOnDemand() )
          {
            s.drawPolygon( g, xColor );
          }
        }
      }
    } else
    {
      if ( xColor != null ) g.setXORMode( xColor ); else g.setColor( color );

      if (lstSegments == null)
      {
        calcLstSegments();
      }
      if (!lstSegments.isEmpty() )
      {
        boolean f = false;
        ArrayList a = new ArrayList();
        ListIterator ia = null;
        int[] seg = null, seg2 = null;
        Segment sg = null;
        Iterator ils = lstSegments.iterator();
        while (ils.hasNext() )
        {
          sg = (Segment)ils.next();
          seg = sg.calcProjection(obsZ, x, y, z, scaleX, scaleY, offsetX, offsetY);
          a.add(seg);
          if (v != null) if (sg.isBack(v.getTabSurfacesToDraw(), x, y, z) ) continue;
          if ( (seg = sg.calcProjection(obsZ, x, y, z, scaleX, scaleY, offsetX, offsetY) ) == null) continue;
          if (a.isEmpty() )
          {
            a.add(seg);
            continue;
          }
          f = false;
          ia = a.listIterator();
          while (ia.hasNext() )
          {
            if ( (seg2 = Segment.equalsProjection( (int[] )ia.next(), seg) ) != null )
            {
              f = true;
              seg = seg2;
              ia.remove();
            }
          }
          a.add(seg);
        }
        int nb1 = 0 , nb2 = 0;
        ia = a.listIterator();
        while (ia.hasNext() )
        {
          nb1++;
          seg2 = ( (int[] )ia.next() );
          if (seg2 != null){
           g.drawLine(seg2[0], seg2[1], seg2[2], seg2[3] );
           nb2++;
          }
        }
        nb1++;
      }
    }
    if ( xColor != null ) g.setPaintMode();

  }

  //-----------------------------------------------------------------------------
  private Object[] calcSurfacesToDraw(double x, double y, double z)
  {
    if ( (lstSurfaces == null) || (lstSurfaces.isEmpty() ) ) return null;

    ArrayList lstSurfacesToDraw = new ArrayList();

    obsX = x; obsY = y; obsZ = z;

    Surface s = null;

    ArrayList lstPoints = null;

    Point p1 = null;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while (iLstSurfaces.hasNext() )
    {
      s = (Surface)iLstSurfaces.next();
      lstPoints = s.getLstPoints();
      p1 = (Point)lstPoints.get(0);
      if ( ( s.getScalarProductZ() * (p1.getZ() - z) +
             s.getScalarProductX() * (p1.getX() - x) +
             s.getScalarProductY() * (p1.getY() - y) ) > 0)
      {
          continue;
      }
      lstSurfacesToDraw.add(s);
    }

    tabSurfacesToDraw = lstSurfacesToDraw.toArray();
    Arrays.sort(tabSurfacesToDraw, new Comparator() {
                                                  public int compare(Object o1, Object o2){
                                                              return ( (int)(calcDistance( (Surface)o2, Volume.this.obsX, Volume.this.obsY, Volume.this.obsZ) -
                                                              calcDistance( (Surface)o1, Volume.this.obsX, Volume.this.obsY, Volume.this.obsZ) ));
                                                  }});

    return tabSurfacesToDraw;
  }

  //-----------------------------------------------------------------------------
  private static Object[] staticCalcSurfacesToDraw(ArrayList lstSurfaces, final double x, final double y, final double z)
  {
    if ( (lstSurfaces == null) || (lstSurfaces.isEmpty() ) ) return null;

    ArrayList lstSurfacesToDraw = new ArrayList();

    Object[] tabSurfacesToDraw = null;

    Surface s = null;

    ArrayList lstPoints = null;

    Point p1 = null;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while (iLstSurfaces.hasNext() )
    {
      s = (Surface)iLstSurfaces.next();
      lstPoints = s.getLstPoints();
      p1 = (Point)lstPoints.get(0);
      if ( ( s.getScalarProductZ() * (p1.getZ() - z) +
             s.getScalarProductX() * (p1.getX() - x) +
             s.getScalarProductY() * (p1.getY() - y) ) > 0)
      {
          continue;
      }
      lstSurfacesToDraw.add(s);
    }

    tabSurfacesToDraw = lstSurfacesToDraw.toArray();
    Arrays.sort(tabSurfacesToDraw, new Comparator() {
                                                  public int compare(Object o1, Object o2){
                                                              return ( (int)(calcDistance( (Surface)o2, x, y, z) -
                                                              calcDistance( (Surface)o1, x, y, z) ));
                                                  }});

    return tabSurfacesToDraw;
  }

  //-----------------------------------------------------------------------------
  public static double calcDistance(Surface s, double xO, double yO, double zO)
  {
    ArrayList lstPoints = s.getLstPoints();
    Iterator iLstPoints = lstPoints.iterator();

    int x = 0, y = 0, z = 0;
    Point p = null;

    int nbPoints = lstPoints.size();

    while (iLstPoints.hasNext() )
    {
      p = (Point)iLstPoints.next();
      x += p.getX();
      y += p.getY();
      z += p.getZ();
    }
    x /= nbPoints;
    y /= nbPoints;
    z /= nbPoints;

    return ( (x - xO) * (x - xO) + (y - yO) * (y - yO) + (z - zO) * (z - zO) );
  }

  //-----------------------------------------------------------------------------
  public boolean intersect(Volume v)
  {
    if ( (lstSurfaces == null) || (lstSurfaces.isEmpty() ) ) return false;

    ArrayList vLstMiddles = v.getLstMiddles();

    if ( (vLstMiddles == null) || (vLstMiddles.isEmpty() ) ) return false;

    boolean f = false;

    Point pV = null;

    Iterator iVLstMiddles = vLstMiddles.iterator();
    while(iVLstMiddles.hasNext() )
    {
      pV = (Point)iVLstMiddles.next();
      Iterator iLstMiddles = lstMiddles.iterator();
      while (iLstMiddles.hasNext() )
      {
        if ( pV.compareTo( (Point)iLstMiddles.next() ) == 0 )
        {
          return true;
        }
      }
    }

    return false;
  }

  //-----------------------------------------------------------------------------
  public boolean isVolumeAllInside(Volume v)
  {
    if ( (lstSurfaces == null) || (lstSurfaces.isEmpty() ) ) return false;

    ArrayList vLstMiddles = v.getLstMiddles();

    if ( (vLstMiddles == null) || (vLstMiddles.isEmpty() ) ) return false;

    Point pV = null;
    int nb = 0;

    Iterator iVLstMiddles = vLstMiddles.iterator();
    while(iVLstMiddles.hasNext() )
    {
      nb = lstMiddles.size();
      pV = (Point)iVLstMiddles.next();
      Iterator iLstMiddles = lstMiddles.iterator();
      while (iLstMiddles.hasNext() )
      {
        if ( pV.compareTo( (Point)iLstMiddles.next() ) == 0 )
        {
          break;
        }
        nb--;
      }
      if (nb == 0)
      {
        return false;
      }
    }

    return true;
  }

  //-----------------------------------------------------------------------------
  public boolean insertVolume( Volume v )
  {
    addMiddles( v.getLstMiddles() );
    addSurfaces( v.getLstSurfaces() , true , false , true , true );
    calcMiddlePointOfVolume();
    return ( eraseStage() );
  }

  //-----------------------------------------------------------------------------
  public void setColor(Color c)
  {
    if (c == null) return;

    if (lstSurfaces == null) return;

    if (lstSurfaces.isEmpty() ) return;

    color = c;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      ( (Surface)iLstSurfaces.next() ).setColor(c);
    }
  }

  //-----------------------------------------------------------------------------
  public void setCalculateForNewPosition(boolean f)
  {
    calculateForNewPosition = f;
  }

  //-----------------------------------------------------------------------------
  public void finalize()
  {
    if (lstSurfaces == null) return;

    if (lstSurfaces.isEmpty() ) return;

    Iterator iLstSurfaces = lstSurfaces.iterator();
    while(iLstSurfaces.hasNext() )
    {
      ( (Surface)iLstSurfaces.next() ).finalize();
    }
    lstSurfaces.clear();

    middle = null;

    rotate = null;
  }

  //-----------------------------------------------------------------------------
  void setNbStages(short[][][] v)
  {
    nbStages = v[0][0].length;
    stages = new int[nbStages];
    nbPerStages = v.length * v[0].length;
  }

}
